/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process;

import com.suncode.pwfl.util.exception.ServiceException;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Date;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;

@Entity
@Table(name="pm_activitycomments")
@SequenceGenerator(name="pm_activitycommnets_id_seq", sequenceName="pm_activitycomments_id_seq")
public class Comment {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_activitycommnets_id_seq")
    private Long id;
    private String processId;
    private String processDefId;
    private String activityId;
    private String activityDefId;
    private String userId;
    @Column(name="activity_comment")
    private String comment;
    private Long timestamp;

    @Transient
    public Date getCommentDate() {
        if (this.timestamp != null) {
            return new Date(this.timestamp);
        }
        return null;
    }

    @Transient
    public String getUserFullName() {
        try {
            return Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(this.userId);
        }
        catch (BaseException e) {
            throw new ServiceException(e);
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getActivityDefId() {
        return this.activityDefId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getComment() {
        return this.comment;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public void setActivityDefId(String activityDefId) {
        this.activityDefId = activityDefId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }
}

