/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.google.common.util.concurrent.UncheckedExecutionException;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.config.InMemoryCacheConfig;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserIdCache {
    private static final Logger log = LoggerFactory.getLogger(UserIdCache.class);
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private CacheFactory cacheFactory;
    private PlusWorkflowCache<String, Long> usernameToIdCache;
    private PlusWorkflowCache<Long, String> idToUsernameCache;

    @PostConstruct
    private void init() {
        this.usernameToIdCache = this.cacheFactory.createInMemoryCache(SystemCacheId.USERNAME_TO_ID_CACHE, InMemoryCacheConfig.builder().expireAfterWrite(Duration.ofSeconds(30L)).loadFunction(username -> {
            User user = this.userFinder.findByUserName((String)username, new String[0]);
            if (Objects.isNull(user)) {
                log.error("User not found in database: " + username);
                return 0L;
            }
            return user.getObjectId();
        }).build());
        this.idToUsernameCache = this.cacheFactory.createInMemoryCache(SystemCacheId.ID_TO_USERNAME_CACHE, InMemoryCacheConfig.builder().expireAfterWrite(Duration.ofSeconds(30L)).loadFunction(id -> {
            User user = (User)this.userFinder.get(id);
            if (user != null) {
                this.usernameToIdCache.put(user.getUserName(), (Long)id);
                return user.getUserName();
            }
            throw new UserNotFoundException(String.format("User not found in database by id [%s]", id));
        }).build());
    }

    public Long getUserIdByUsername(String username) {
        return this.usernameToIdCache.getUnchecked(username);
    }

    public String getUsernameById(Long id) {
        try {
            return this.idToUsernameCache.getUnchecked(id);
        }
        catch (UncheckedExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof UserNotFoundException) {
                UserNotFoundException userNotFoundException = (UserNotFoundException)throwable;
                throw userNotFoundException;
            }
            throw e;
        }
    }
}

