/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.web.ui.DivanteColor;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;
import java.util.Arrays;

@Entity
@Table(name="pm_user_avatar")
@SequenceGenerator(name="pm_user_avatar_id_seq", sequenceName="pm_user_avatar_id_seq")
public class UserAvatar {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_user_avatar_id_seq")
    private Long id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="userid")
    private User user;
    @Lob
    private byte[] avatar;
    private boolean mini;
    @Enumerated(value=EnumType.STRING)
    private DivanteColor backgroundColor;
    @Lob
    @Column(name="generatedavatar")
    private byte[] generatedAvatar;

    public static UserAvatarBuilder builder() {
        return new UserAvatarBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public User getUser() {
        return this.user;
    }

    public byte[] getAvatar() {
        return this.avatar;
    }

    public boolean isMini() {
        return this.mini;
    }

    public DivanteColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public byte[] getGeneratedAvatar() {
        return this.generatedAvatar;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setAvatar(byte[] avatar) {
        this.avatar = avatar;
    }

    public void setMini(boolean mini) {
        this.mini = mini;
    }

    public void setBackgroundColor(DivanteColor backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setGeneratedAvatar(byte[] generatedAvatar) {
        this.generatedAvatar = generatedAvatar;
    }

    public UserAvatar() {
    }

    @ConstructorProperties(value={"id", "user", "avatar", "mini", "backgroundColor", "generatedAvatar"})
    public UserAvatar(Long id, User user, byte[] avatar, boolean mini, DivanteColor backgroundColor, byte[] generatedAvatar) {
        this.id = id;
        this.user = user;
        this.avatar = avatar;
        this.mini = mini;
        this.backgroundColor = backgroundColor;
        this.generatedAvatar = generatedAvatar;
    }

    public static class UserAvatarBuilder {
        private Long id;
        private User user;
        private byte[] avatar;
        private boolean mini;
        private DivanteColor backgroundColor;
        private byte[] generatedAvatar;

        UserAvatarBuilder() {
        }

        public UserAvatarBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public UserAvatarBuilder user(User user) {
            this.user = user;
            return this;
        }

        public UserAvatarBuilder avatar(byte[] avatar) {
            this.avatar = avatar;
            return this;
        }

        public UserAvatarBuilder mini(boolean mini) {
            this.mini = mini;
            return this;
        }

        public UserAvatarBuilder backgroundColor(DivanteColor backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public UserAvatarBuilder generatedAvatar(byte[] generatedAvatar) {
            this.generatedAvatar = generatedAvatar;
            return this;
        }

        public UserAvatar build() {
            return new UserAvatar(this.id, this.user, this.avatar, this.mini, this.backgroundColor, this.generatedAvatar);
        }

        public String toString() {
            return "UserAvatar.UserAvatarBuilder(id=" + this.id + ", user=" + String.valueOf(this.user) + ", avatar=" + Arrays.toString(this.avatar) + ", mini=" + this.mini + ", backgroundColor=" + String.valueOf((Object)this.backgroundColor) + ", generatedAvatar=" + Arrays.toString(this.generatedAvatar) + ")";
        }
    }
}

