/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.action;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.DtButtonDefinition;
import com.suncode.pwfl.component.ParameterDefinition;
import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.component.ContextVariable;
import com.suncode.pwfl.workflow.component.WorkflowComponent;
import com.suncode.pwfl.workflow.form.action.ActionDestination;
import com.suncode.pwfl.workflow.form.action.ActionTarget;
import com.suncode.pwfl.workflow.form.action.ActionUIFragment;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.util.CollectionUtils;

public class ActionDefinition
extends WorkflowComponent {
    private final List<ActionDestination> destinations;
    private ActionUIFragment[] fragments;
    private final List<DtButtonDefinition> dtButtons;

    public ActionDefinition(String id, LocalizedString name) {
        this(id, null, name, null, null, null, null, null, null, null, null);
    }

    public ActionDefinition(String id, String documentationLink, LocalizedString name, LocalizedString description, Icon icon, List<Category> categories, List<ActionDestination> destinations, List<ParameterDefinition<?>> parameters, List<ContextVariable<?>> contextVariables, List<DtButtonDefinition> dtButtons, LocalizedString deprecationDescription) {
        super(id, documentationLink, name, description, icon, categories, parameters, contextVariables, deprecationDescription);
        this.destinations = CollectionUtils.isEmpty(destinations) ? ImmutableList.of((Object)ActionDestination.form()) : ImmutableList.copyOf(destinations);
        this.dtButtons = CollectionUtils.isEmpty(dtButtons) ? new ArrayList<DtButtonDefinition>() : ImmutableList.copyOf(dtButtons);
    }

    public List<ActionDestination> getDestinations() {
        return this.destinations;
    }

    public List<ActionDestination.Type> getDestinationsTypes() {
        ArrayList types = Lists.newArrayList();
        for (ActionDestination destination : this.destinations) {
            types.add(destination.getType());
        }
        return types;
    }

    public ActionDestination getDestination(ActionTarget actionTarget) {
        for (ActionDestination destination : this.destinations) {
            if (!destination.matchesTarget(actionTarget)) continue;
            return destination;
        }
        throw new IllegalArgumentException("There is no matching destination for given target: " + String.valueOf(actionTarget));
    }

    public boolean targetSupported(ActionTarget actionTarget) {
        for (ActionDestination destination : this.destinations) {
            if (!destination.matchesTarget(actionTarget)) continue;
            return true;
        }
        return false;
    }

    public void setFragments(ActionUIFragment[] fragments) {
        this.fragments = fragments;
    }

    public boolean fragmentSupported(ActionUIFragment fragment) {
        ActionUIFragment tempFragment = fragment == ActionUIFragment.FORM_MOBILE ? ActionUIFragment.FORM : fragment;
        for (ActionUIFragment supportedFragment : this.fragments) {
            if (!supportedFragment.equals((Object)tempFragment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ActionDefinition) {
            ActionDefinition other = (ActionDefinition)obj;
            return new EqualsBuilder().appendSuper(super.equals(other)).append(this.destinations, other.destinations).isEquals();
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.destinations).toHashCode();
    }

    public ActionUIFragment[] getFragments() {
        return this.fragments;
    }

    public List<DtButtonDefinition> getDtButtons() {
        return this.dtButtons;
    }
}

