/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.email.oauth.connection;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;

@Entity
@Table(name="pm_oauth_connection")
@SequenceGenerator(name="pm_oauth_connection_id_seq", sequenceName="pm_oauth_connection_id_seq")
public class OAuth2Connection {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_oauth_connection_id_seq")
    private Long id;
    @Column(length=4000)
    private String accessToken;
    @Column(length=4000)
    private String refreshToken;
    private Long expires;
    private Long clientId;
    @Column(length=512)
    private String scope;
    @Column(length=512)
    private String email;

    public static OAuth2ConnectionBuilder builder() {
        return new OAuth2ConnectionBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Long getExpires() {
        return this.expires;
    }

    public Long getClientId() {
        return this.clientId;
    }

    public String getScope() {
        return this.scope;
    }

    public String getEmail() {
        return this.email;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setExpires(Long expires) {
        this.expires = expires;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public OAuth2Connection() {
    }

    @ConstructorProperties(value={"id", "accessToken", "refreshToken", "expires", "clientId", "scope", "email"})
    public OAuth2Connection(Long id, String accessToken, String refreshToken, Long expires, Long clientId, String scope, String email) {
        this.id = id;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expires = expires;
        this.clientId = clientId;
        this.scope = scope;
        this.email = email;
    }

    public static class OAuth2ConnectionBuilder {
        private Long id;
        private String accessToken;
        private String refreshToken;
        private Long expires;
        private Long clientId;
        private String scope;
        private String email;

        OAuth2ConnectionBuilder() {
        }

        public OAuth2ConnectionBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public OAuth2ConnectionBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public OAuth2ConnectionBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public OAuth2ConnectionBuilder expires(Long expires) {
            this.expires = expires;
            return this;
        }

        public OAuth2ConnectionBuilder clientId(Long clientId) {
            this.clientId = clientId;
            return this;
        }

        public OAuth2ConnectionBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public OAuth2ConnectionBuilder email(String email) {
            this.email = email;
            return this;
        }

        public OAuth2Connection build() {
            return new OAuth2Connection(this.id, this.accessToken, this.refreshToken, this.expires, this.clientId, this.scope, this.email);
        }

        public String toString() {
            return "OAuth2Connection.OAuth2ConnectionBuilder(id=" + this.id + ", accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", expires=" + this.expires + ", clientId=" + this.clientId + ", scope=" + this.scope + ", email=" + this.email + ")";
        }
    }
}

