/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.suncode.pwfl.SystemContext;
import com.suncode.pwfl.i18n.MessageHelper;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class ViewResultAction {
    private ViewResultActionType type;
    private String nameKey;
    private String relativePath;
    private String confirmationKey;
    private Map<String, String> parameters;

    @JsonIgnore
    public String getName() {
        return MessageHelper.getMessage((String)this.nameKey);
    }

    @JsonIgnore
    public Optional<String> getConfirmation() {
        if (!this.hasConfirmation()) {
            return Optional.empty();
        }
        return Optional.of(MessageHelper.getMessage((String)this.confirmationKey) + "?");
    }

    @JsonIgnore
    private boolean hasConfirmation() {
        return StringUtils.isNotBlank((CharSequence)this.confirmationKey);
    }

    @JsonIgnore
    public String getLink() {
        String basePath = SystemContext.get().getServletContext().getContextPath() + "/" + this.relativePath;
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)basePath);
        this.parameters.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
        return builder.build().toUriString();
    }

    @JsonIgnore
    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public static ViewResultAction ofOpenActivity(String processId, String activityId, Long viewId) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("processKey", processId);
        parameters.put("activityId", activityId);
        if (viewId != null) {
            parameters.put("viewId", viewId.toString());
            parameters.put("acceptanceSource", "view");
        }
        return new ViewResultAction(ViewResultActionType.OpenActivity, "Wykonaj", "ProcesActivity.do", null, parameters);
    }

    public static ViewResultAction ofShowActivityDetails(String processId, String activityId, Long viewId, String token) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("ProcessId", processId);
        parameters.put("histActivityId", activityId);
        if (viewId != null) {
            parameters.put("viewId", viewId.toString());
            parameters.put("acceptanceSource", "view");
        }
        if (StringUtils.isNotBlank((CharSequence)token)) {
            parameters.put("key", token);
        }
        return new ViewResultAction(ViewResultActionType.ShowActivityDetails, "Szczegoly", "ShowDetailHistory.do", null, parameters);
    }

    public static ViewResultAction ofResumeActivity(String processId, String activityId) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("ProcessId", processId);
        parameters.put("ActivityId", activityId);
        return new ViewResultAction(ViewResultActionType.ResumeActivity, "Przywroc_zadanie", "ResumeActivity.do", "Czy_na_pewno_chcesz_przywrocic", parameters);
    }

    public static ViewResultAction ofAbortActivity(String processId, String activityId) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("ProcessId", processId);
        parameters.put("ActivityId", activityId);
        return new ViewResultAction(ViewResultActionType.AbortActivity, "Anuluj_zadanie", "AbortActivity.do", null, parameters);
    }

    public static ViewResultAction ofSuspendActivity(String processId, String activityId) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("ProcessId", processId);
        parameters.put("ActivityId", activityId);
        return new ViewResultAction(ViewResultActionType.SuspendActivity, "Zawies_zadanie", "SuspendActivity.do", "Czy_na_pewno_chcesz_zawiesic", parameters);
    }

    public static ViewResultAction ofShowProcessHistory(String processId, String token) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("ProcessId", processId);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            parameters.put("key", token);
        }
        return new ViewResultAction(ViewResultActionType.ShowProcessHistory, "Historia", "ShowProcessHistory.do", null, parameters);
    }

    public static ViewResultAction ofAbortProcess(String processId) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("ProcessId", processId);
        return new ViewResultAction(ViewResultActionType.AbortProcess, "Anuluj", "AbortProcess.do", "Czy_na_pewno_chcesz_anulowac", parameters);
    }

    public static ViewResultAction ofDeleteProcess(String processId) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("ProcessId", processId);
        return new ViewResultAction(ViewResultActionType.DeleteProcess, "Usun", "DeleteProcess.do", "Czy_na_pewno_chcesz_usunac", parameters);
    }

    public ViewResultActionType getType() {
        return this.type;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getConfirmationKey() {
        return this.confirmationKey;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @ConstructorProperties(value={"type", "nameKey", "relativePath", "confirmationKey", "parameters"})
    public ViewResultAction(ViewResultActionType type, String nameKey, String relativePath, String confirmationKey, Map<String, String> parameters) {
        this.type = type;
        this.nameKey = nameKey;
        this.relativePath = relativePath;
        this.confirmationKey = confirmationKey;
        this.parameters = parameters;
    }

    public static enum ViewResultActionType {
        OpenActivity,
        ShowActivityDetails,
        ResumeActivity,
        SuspendActivity,
        AbortActivity,
        ShowProcessHistory,
        AbortProcess,
        DeleteProcess;

    }
}

