/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;

public class LinkDto {
    private Long id;
    private String name;
    private String translatedName;
    private String description;
    private String translatedDescription;
    private String iconName;
    private String iconColor;
    private List<String> associatedDocumentClassesNames;

    public static LinkDto fromEntity(Link link) {
        LinkService linkService = ServiceFactory.getLinkService();
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        List<String> documentClassesNames = linkService.getLinkConnectionsForLink(link.getId(), "documentClass").stream().map(linkConnection -> documentClassService.getDocumentClassTranslation(linkConnection.getDocumentClass().getId(), TranslatedFieldType.NAME)).distinct().collect(Collectors.toList());
        return LinkDto.builder().id(link.getId()).name(link.getName()).description(link.getDescription()).translatedName(linkService.getLinkTranslation(link.getId(), TranslatedFieldType.NAME)).translatedDescription(linkService.getLinkTranslation(link.getId(), TranslatedFieldType.DESCRIPTION)).iconName(link.getIconName()).iconColor(link.getIconColor()).associatedDocumentClassesNames(documentClassesNames).build();
    }

    @ConstructorProperties(value={"id", "name", "translatedName", "description", "translatedDescription", "iconName", "iconColor", "associatedDocumentClassesNames"})
    LinkDto(Long id, String name, String translatedName, String description, String translatedDescription, String iconName, String iconColor, List<String> associatedDocumentClassesNames) {
        this.id = id;
        this.name = name;
        this.translatedName = translatedName;
        this.description = description;
        this.translatedDescription = translatedDescription;
        this.iconName = iconName;
        this.iconColor = iconColor;
        this.associatedDocumentClassesNames = associatedDocumentClassesNames;
    }

    public static LinkDtoBuilder builder() {
        return new LinkDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslatedName() {
        return this.translatedName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTranslatedDescription() {
        return this.translatedDescription;
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getIconColor() {
        return this.iconColor;
    }

    public List<String> getAssociatedDocumentClassesNames() {
        return this.associatedDocumentClassesNames;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTranslatedName(String translatedName) {
        this.translatedName = translatedName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTranslatedDescription(String translatedDescription) {
        this.translatedDescription = translatedDescription;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public void setIconColor(String iconColor) {
        this.iconColor = iconColor;
    }

    public void setAssociatedDocumentClassesNames(List<String> associatedDocumentClassesNames) {
        this.associatedDocumentClassesNames = associatedDocumentClassesNames;
    }

    public static class LinkDtoBuilder {
        private Long id;
        private String name;
        private String translatedName;
        private String description;
        private String translatedDescription;
        private String iconName;
        private String iconColor;
        private List<String> associatedDocumentClassesNames;

        LinkDtoBuilder() {
        }

        public LinkDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public LinkDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LinkDtoBuilder translatedName(String translatedName) {
            this.translatedName = translatedName;
            return this;
        }

        public LinkDtoBuilder description(String description) {
            this.description = description;
            return this;
        }

        public LinkDtoBuilder translatedDescription(String translatedDescription) {
            this.translatedDescription = translatedDescription;
            return this;
        }

        public LinkDtoBuilder iconName(String iconName) {
            this.iconName = iconName;
            return this;
        }

        public LinkDtoBuilder iconColor(String iconColor) {
            this.iconColor = iconColor;
            return this;
        }

        public LinkDtoBuilder associatedDocumentClassesNames(List<String> associatedDocumentClassesNames) {
            this.associatedDocumentClassesNames = associatedDocumentClassesNames;
            return this;
        }

        public LinkDto build() {
            return new LinkDto(this.id, this.name, this.translatedName, this.description, this.translatedDescription, this.iconName, this.iconColor, this.associatedDocumentClassesNames);
        }

        public String toString() {
            return "LinkDto.LinkDtoBuilder(id=" + this.id + ", name=" + this.name + ", translatedName=" + this.translatedName + ", description=" + this.description + ", translatedDescription=" + this.translatedDescription + ", iconName=" + this.iconName + ", iconColor=" + this.iconColor + ", associatedDocumentClassesNames=" + String.valueOf(this.associatedDocumentClassesNames) + ")";
        }
    }
}

