/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.security.extraverifiers;

import com.suncode.pwfl.security.extraverifiers.AuthenticationParameters;
import com.suncode.pwfl.security.extraverifiers.ExtraAuthVerifierValueProvider;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class ExtraAuthVerifier {
    private static final Logger log = Logger.getLogger(ExtraAuthVerifier.class);
    private ExtraAuthVerifierValueProvider firstValueProvider;
    private ExtraAuthVerifierValueProvider secondValueProvider;
    private boolean ignoreCase;

    public boolean isValid(AuthenticationParameters authenticationParameters) {
        List<String> firstValues = this.firstValueProvider.getValuesToCompare(authenticationParameters);
        List<String> secondValues = this.secondValueProvider.getValuesToCompare(authenticationParameters);
        if (firstValues == null && secondValues == null) {
            log.warn((Object)"Both extra auth verifier values are null");
            return false;
        }
        if (firstValues == null || secondValues == null) {
            return false;
        }
        if (this.ignoreCase) {
            firstValues = firstValues.stream().map(String::toLowerCase).collect(Collectors.toList());
            secondValues = secondValues.stream().map(String::toLowerCase).collect(Collectors.toList());
        }
        return CollectionUtils.isEqualCollection(firstValues, secondValues);
    }

    @ConstructorProperties(value={"firstValueProvider", "secondValueProvider", "ignoreCase"})
    public ExtraAuthVerifier(ExtraAuthVerifierValueProvider firstValueProvider, ExtraAuthVerifierValueProvider secondValueProvider, boolean ignoreCase) {
        this.firstValueProvider = firstValueProvider;
        this.secondValueProvider = secondValueProvider;
        this.ignoreCase = ignoreCase;
    }

    public ExtraAuthVerifierValueProvider getFirstValueProvider() {
        return this.firstValueProvider;
    }

    public ExtraAuthVerifierValueProvider getSecondValueProvider() {
        return this.secondValueProvider;
    }
}

