/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.datasource.dao;

import com.suncode.pwfl.datasource.dao.DataSourceDeclaration;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;
import java.util.List;

@Entity
@Table(name="pm_datasource_category")
@SequenceGenerator(name="pm_datasource_category_id_seq", sequenceName="pm_datasource_category_id_seq")
public class DataSourceCategory {
    public static final String JOIN_DECLARATIONS = "dataSourceDeclarations";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_datasource_category_id_seq")
    private Long id;
    @Column(unique=true, nullable=false)
    private String name;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="category")
    private List<DataSourceDeclaration> dataSourceDeclarations;

    public DataSourceCategory(String name) {
        this.name = name;
    }

    public static DataSourceCategoryBuilder builder() {
        return new DataSourceCategoryBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<DataSourceDeclaration> getDataSourceDeclarations() {
        return this.dataSourceDeclarations;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDataSourceDeclarations(List<DataSourceDeclaration> dataSourceDeclarations) {
        this.dataSourceDeclarations = dataSourceDeclarations;
    }

    public DataSourceCategory() {
    }

    @ConstructorProperties(value={"id", "name", "dataSourceDeclarations"})
    public DataSourceCategory(Long id, String name, List<DataSourceDeclaration> dataSourceDeclarations) {
        this.id = id;
        this.name = name;
        this.dataSourceDeclarations = dataSourceDeclarations;
    }

    public static class DataSourceCategoryBuilder {
        private Long id;
        private String name;
        private List<DataSourceDeclaration> dataSourceDeclarations;

        DataSourceCategoryBuilder() {
        }

        public DataSourceCategoryBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public DataSourceCategoryBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DataSourceCategoryBuilder dataSourceDeclarations(List<DataSourceDeclaration> dataSourceDeclarations) {
            this.dataSourceDeclarations = dataSourceDeclarations;
            return this;
        }

        public DataSourceCategory build() {
            return new DataSourceCategory(this.id, this.name, this.dataSourceDeclarations);
        }

        public String toString() {
            return "DataSourceCategory.DataSourceCategoryBuilder(id=" + this.id + ", name=" + this.name + ", dataSourceDeclarations=" + String.valueOf(this.dataSourceDeclarations) + ")";
        }
    }
}

