/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;

public enum BasicTypes {
    BOOLEAN(Types.BOOLEAN),
    STRING(Types.STRING),
    INTEGER(Types.INTEGER),
    FLOAT(Types.FLOAT),
    DATE(Types.DATE),
    DATETIME(Types.DATETIME),
    BOOLEAN_ARRAY(Types.BOOLEAN_ARRAY),
    STRING_ARRAY(Types.STRING_ARRAY),
    INTEGER_ARRAY(Types.INTEGER_ARRAY),
    FLOAT_ARRAY(Types.FLOAT_ARRAY),
    DATE_ARRAY(Types.DATE_ARRAY),
    DATETIME_ARRAY(Types.DATETIME_ARRAY);

    private Type<?> type;

    private BasicTypes(Type<?> type) {
        this.type = type;
    }

    public Type<?> getType() {
        return this.type;
    }

    public static Type<?> of(Class<?> clazz) {
        Type<?> type = Types.typeOf(clazz);
        if (!BasicTypes.isBasic(type)) {
            throw new IllegalArgumentException("There is not BasicType mapped to java class " + String.valueOf(type));
        }
        return type;
    }

    public static BasicTypes wrap(Type<?> type) {
        for (BasicTypes basicType : BasicTypes.values()) {
            if (!basicType.type.equals(type)) continue;
            return basicType;
        }
        throw new IllegalArgumentException("There is not BasicType mapped to java class " + String.valueOf(type));
    }

    public static boolean isBasic(Type<?> type) {
        for (BasicTypes basicType : BasicTypes.values()) {
            if (!basicType.type.equals(type)) continue;
            return true;
        }
        return false;
    }
}

