/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl;

import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.xpdl.XpdlElementType;
import com.suncode.pwfl.xpdl.differences.XpdlElementDifference;
import com.suncode.pwfl.xpdl.differences.XpdlModificationType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class XpdlElement {
    private static final String DIFFERENCE_TRANSLATION_PREFIX = "xpdl_differences_";
    private XpdlElementType xpdlElement;
    private List<XpdlElementDifference> differences;
    private XpdlElement parent;
    private List<XpdlElement> children = new ArrayList<XpdlElement>();
    private String elementDisplayName;

    public XpdlElement(XpdlElementType xpdlObjectType, List<XpdlElementDifference> differences, XpdlElement parent) {
        this.xpdlElement = xpdlObjectType;
        this.differences = differences;
        this.parent = parent;
    }

    public XpdlElement(XpdlElementType xpdlObjectType, List<XpdlElementDifference> differences, XpdlElement parent, String elementDisplayName) {
        this(xpdlObjectType, differences, parent);
        this.elementDisplayName = elementDisplayName;
    }

    public void addChildren(List<XpdlElement> children) {
        children.forEach(child -> child.setParent(this));
        this.children.addAll(children);
    }

    public List<String> getXpdlDifferencesTranslatedText() {
        return this.getXpdlDifferencesTranslatedText(1, null);
    }

    public List<String> getXpdlDifferencesTranslatedText(String levelPrefix) {
        if (StringUtils.isBlank((CharSequence)levelPrefix)) {
            levelPrefix = "";
        }
        return this.getXpdlDifferencesTranslatedText(1, levelPrefix);
    }

    private List<String> getXpdlDifferencesTranslatedText(int level, String levelPrefix) {
        ArrayList<String> differencesText = new ArrayList<String>();
        String from = MessageHelper.getMessage((String)"xpdl_differences_FROM");
        String to = MessageHelper.getMessage((String)"xpdl_differences_TO");
        for (XpdlElementDifference difference : this.differences) {
            String baseText = String.format("%s - %s: %s", MessageHelper.getMessage((String)(DIFFERENCE_TRANSLATION_PREFIX + String.valueOf((Object)this.xpdlElement))), this.getTranslatedModificationType(difference.getModificationType()), MessageHelper.getMessage((String)(DIFFERENCE_TRANSLATION_PREFIX + String.valueOf((Object)difference.getXpdlElementDifferenceType()))).toLowerCase());
            differencesText.add(levelPrefix.repeat(level) + (switch (difference.getModificationType()) {
                case XpdlModificationType.MODIFIED -> {
                    boolean fromAndToBlank = StringUtils.isBlank((CharSequence)difference.getOldValue()) && StringUtils.isBlank((CharSequence)difference.getNewValue());
                    yield fromAndToBlank ? baseText : String.format("%s - %s '%s' %s '%s'", baseText, from, difference.getOldValue(), to, difference.getNewValue());
                }
                case XpdlModificationType.ADDED -> {
                    String newValue = difference.getNewValue();
                    yield StringUtils.isNotBlank((CharSequence)newValue) ? baseText + " - '" + newValue + "'" : baseText;
                }
                case XpdlModificationType.DELETED -> {
                    String oldValue = difference.getOldValue();
                    yield StringUtils.isNotBlank((CharSequence)oldValue) ? baseText + " - '" + oldValue + "'" : baseText;
                }
                default -> baseText;
            }));
        }
        ArrayList<String> childDifferences = new ArrayList<String>();
        for (XpdlElement child : this.children) {
            childDifferences.addAll(child.getXpdlDifferencesTranslatedText(level + 1, levelPrefix));
        }
        if (!childDifferences.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)this.elementDisplayName)) {
                differencesText.add(levelPrefix.repeat(level) + MessageHelper.getMessage((String)(DIFFERENCE_TRANSLATION_PREFIX + String.valueOf((Object)this.xpdlElement))) + ": " + this.elementDisplayName);
            }
            differencesText.addAll(childDifferences);
        }
        return differencesText;
    }

    private String getTranslatedModificationType(XpdlModificationType modificationType) {
        if (modificationType == null) {
            return "";
        }
        return switch (modificationType) {
            default -> throw new IncompatibleClassChangeError();
            case XpdlModificationType.ADDED -> MessageHelper.getMessage((String)"xpdl_differences_added");
            case XpdlModificationType.MODIFIED -> MessageHelper.getMessage((String)"xpdl_differences_modified");
            case XpdlModificationType.DELETED -> MessageHelper.getMessage((String)"xpdl_differences_deleted");
        };
    }

    public XpdlElementType getXpdlElement() {
        return this.xpdlElement;
    }

    public List<XpdlElementDifference> getDifferences() {
        return this.differences;
    }

    public XpdlElement getParent() {
        return this.parent;
    }

    public List<XpdlElement> getChildren() {
        return this.children;
    }

    public String getElementDisplayName() {
        return this.elementDisplayName;
    }

    public void setParent(XpdlElement parent) {
        this.parent = parent;
    }
}

