/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process;

public enum ProcessState {
    RUNNING("open.running", 1000000L),
    NOT_STARTED("open.not_running.not_started", 1000002L),
    SUSPENDED("open.not_running.suspended", 1000004L),
    COMPLETED("closed.completed", 1000006L),
    TERMINATED("closed.terminated", 1000008L),
    ABORTED("closed.aborted", 1000010L);

    private String state;
    private long number;

    public static ProcessState getState(String state) {
        if (state == null) {
            return null;
        }
        if (state.equals("open.running")) {
            return RUNNING;
        }
        if (state.equals("open.not_running.not_started")) {
            return NOT_STARTED;
        }
        if (state.equals("open.not_running.suspended")) {
            return SUSPENDED;
        }
        if (state.equals("closed.completed")) {
            return COMPLETED;
        }
        if (state.equals("closed.terminated")) {
            return TERMINATED;
        }
        if (state.equals("closed.aborted")) {
            return ABORTED;
        }
        throw new IllegalArgumentException("Nie obs\u0142ugiwany stan: " + state);
    }

    public String getStateText() {
        return this.state;
    }

    public long getStateNumber() {
        return this.number;
    }

    private ProcessState(String state, long number) {
        this.state = state;
        this.number = number;
    }

    public static boolean isOpen(ProcessState state) {
        return state.equals((Object)RUNNING) || state.equals((Object)NOT_STARTED) || state.equals((Object)SUSPENDED);
    }
}

