/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.cache.config;

import java.time.Duration;
import java.util.function.Function;

public class HybridCacheConfig<K, V> {
    private final Duration expireAfterWrite;
    private final Function<? super K, ? extends V> loadFunction;

    protected HybridCacheConfig(Duration expireAfterWrite, Function<? super K, ? extends V> loadFunction) {
        this.expireAfterWrite = expireAfterWrite;
        this.loadFunction = loadFunction;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public Duration getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public Function<? super K, ? extends V> getLoadFunction() {
        return this.loadFunction;
    }

    public static class Builder<K, V> {
        protected Duration expireAfterWrite;
        protected Function<? super K, ? extends V> loadFunction;

        public Builder<K, V> expireAfterWrite(Duration duration) {
            this.expireAfterWrite = duration;
            return this;
        }

        public Builder<K, V> loadFunction(Function<? super K, ? extends V> loadFunction) {
            this.loadFunction = loadFunction;
            return this;
        }

        public HybridCacheConfig<K, V> build() {
            return new HybridCacheConfig<K, V>(this.expireAfterWrite, this.loadFunction);
        }
    }
}

