/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class Maps {
    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toMap(BinaryOperator<V> mergeFunction) {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toNullableMap() {
        return Collector.of(HashMap::new, (acc, entry) -> {
            if (acc.putIfAbsent(entry.getKey(), entry.getValue()) != null) {
                throw new IllegalStateException(String.format("Duplicate key %s", entry));
            }
        }, (hashMap, hashMap2) -> {
            throw new UnsupportedOperationException("Concurrent stream operation not permitted for that collector");
        }, new Collector.Characteristics[0]);
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K, K2, V> Function<Map.Entry<K, V>, Map.Entry<K2, V>> entryK(Function<K, K2> transform) {
        return Maps.entryFn(transform, Function.identity());
    }

    public static <K, V, V2> Function<Map.Entry<K, V>, Map.Entry<K, V2>> entryV(Function<V, V2> transform) {
        return Maps.entryFn(Function.identity(), transform);
    }

    public static <K, V, K2, V2> Function<Map.Entry<K, V>, Map.Entry<K2, V2>> entryFn(Function<K, K2> key, Function<V, V2> value) {
        return Maps.entryFold((k, v) -> Maps.entry(key.apply(k), value.apply(v)));
    }

    public static <K, V, R> Function<Map.Entry<K, V>, R> entryFold(BiFunction<K, V, R> transform) {
        return entry -> transform.apply(entry.getKey(), entry.getValue());
    }

    public static <K, V> Consumer<Map.Entry<K, V>> consumeEntries(BiConsumer<K, V> consumer) {
        return entry -> consumer.accept(entry.getKey(), entry.getValue());
    }

    public static <K, V> Predicate<Map.Entry<K, V>> testEntries(BiPredicate<K, V> consumer) {
        return entry -> consumer.test(entry.getKey(), entry.getValue());
    }

    public static <K, V1, V2> Map<K, V2> mapValues(Map<K, V1> map, BiFunction<K, V1, V2> transform) {
        return map.entrySet().stream().map(entry -> Maps.entry(entry.getKey(), transform.apply(entry.getKey(), entry.getValue()))).collect(Maps.toMap());
    }

    private Maps() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

