/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class UserInfo {
    private final String userName;
    private final String firstName;
    private final String lastName;
    private String fullName;
    private String email;
    private String number;
    private List<GroupInfo> groups;
    private List<PositionInfo> positions;
    private boolean anonymous;

    public UserInfo(User user) {
        this(user, true);
    }

    public UserInfo(String userName, String firstName, String lastName) {
        this.userName = userName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.fullName = StringUtils.trim((String)(this.firstName + " " + this.lastName));
    }

    public UserInfo(User user, boolean expanded) {
        this.userName = user.getUserName();
        this.firstName = this.def(user.getFirstName());
        this.lastName = this.def(user.getLastName());
        this.fullName = StringUtils.trim((String)(this.firstName + " " + this.lastName));
        this.email = this.def(user.getEmail());
        this.number = this.def(user.getNumber());
        this.anonymous = user.isAnonymous();
        if (expanded) {
            this.groups = Lists.newArrayList();
            this.positions = Lists.newArrayList();
            for (UserGroup group : user.getGroups()) {
                this.groups.add(new GroupInfo(group));
            }
            for (Position position : user.getPositions()) {
                this.positions.add(new PositionInfo(position));
            }
        }
    }

    @JsonCreator
    @ConstructorProperties(value={"userName", "firstName", "lastName", "fullName", "email", "number", "groups", "positions", "anonymous"})
    public UserInfo(String userName, String firstName, String lastName, String fullName, String email, String number, List<GroupInfo> groups, List<PositionInfo> positions, boolean anonymous) {
        this.userName = userName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.fullName = fullName;
        this.email = email;
        this.number = number;
        this.groups = groups;
        this.positions = positions;
        this.anonymous = anonymous;
    }

    public static UserInfo of(User user, boolean expanded) {
        return user != null ? new UserInfo(user, expanded) : null;
    }

    private String def(String value) {
        return value != null ? value : "";
    }

    @JsonIgnore
    public String getInitials() {
        String displayName = StringUtils.isNotBlank((String)this.fullName) ? this.fullName : this.userName;
        return Arrays.stream(displayName.split("\\s+", -1)).filter(StringUtils::isNotBlank).limit(2L).map(word -> word.substring(0, 1)).collect(Collectors.joining()).toUpperCase();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getNumber() {
        return this.number;
    }

    public List<GroupInfo> getGroups() {
        return this.groups;
    }

    public List<PositionInfo> getPositions() {
        return this.positions;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public static class GroupInfo {
        private String name;

        public GroupInfo(UserGroup group) {
            this.name = group.getName();
        }

        @JsonCreator
        @ConstructorProperties(value={"name"})
        public GroupInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class PositionInfo {
        private String name;
        private String symbol;
        private UnitInfo unit;
        private UserInfo user;
        private PositionInfo higherPosition;

        public PositionInfo(Position position) {
            this(position, true);
        }

        public PositionInfo(Position position, boolean expanded) {
            this.name = position.getName();
            this.symbol = position.getSymbol();
            this.user = UserInfo.of(position.getUser(), false);
            if (expanded) {
                this.unit = UnitInfo.of(position.getOrganizationalUnit());
                this.higherPosition = PositionInfo.of(position.getHigherPosition(), false);
            }
        }

        @JsonCreator
        @ConstructorProperties(value={"name", "symbol", "unit", "user", "higherPosition"})
        public PositionInfo(String name, String symbol, UnitInfo unit, UserInfo user, PositionInfo higherPosition) {
            this.name = name;
            this.symbol = symbol;
            this.unit = unit;
            this.user = user;
            this.higherPosition = higherPosition;
        }

        public static PositionInfo of(Position position, boolean expanded) {
            return position != null ? new PositionInfo(position, expanded) : null;
        }

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public UnitInfo getUnit() {
            return this.unit;
        }

        public UserInfo getUser() {
            return this.user;
        }

        public PositionInfo getHigherPosition() {
            return this.higherPosition;
        }
    }

    public static class UnitInfo {
        private String name;
        private String symbol;

        public UnitInfo(OrganizationalUnit unit) {
            this.name = unit.getName();
            this.symbol = unit.getSymbol();
        }

        @JsonCreator
        @ConstructorProperties(value={"name", "symbol"})
        public UnitInfo(String name, String symbol) {
            this.name = name;
            this.symbol = symbol;
        }

        public static UnitInfo of(OrganizationalUnit unit) {
            return unit != null ? new UnitInfo(unit) : null;
        }

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

