/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.configuration.audit;

import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfigurationTransferAudit {
    private final Map<String, Set<String>> result = new HashMap<String, Set<String>>();

    public void addElement(ElementType type) {
        this.addElement(type.toString());
    }

    public void addElement(ElementType type, String value) {
        this.addElement(type.toString(), value);
    }

    public void addElement(String type) {
        this.result.put(type, null);
    }

    public void addElement(String type, String value) {
        this.result.computeIfAbsent(type, v -> new HashSet()).add(value);
    }

    public Set<String> getElement(ElementType type) {
        return Optional.ofNullable(this.result.get(type.toString())).orElse(new HashSet());
    }

    public Map<String, Object> getParameters() {
        return this.result.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (e.getValue() != null) {
                return String.join((CharSequence)", ", (Iterable)e.getValue());
            }
            return MessageHelper.getMessage((String)"Zaimportowane");
        }));
    }

    public static enum ElementType {
        GROUPS,
        USERS,
        DOMAINS,
        POSITIONS,
        ORG_UNITS,
        DEVICES,
        DIRECTORIES,
        DOC_CLASSES,
        DASHBOARDS,
        LINKS,
        PROCESSES_NOTIFICATIONS,
        PROCESSES_TEMPLATES,
        PROCESSES_SETTINGS,
        PROCESSES_DOCUMENT_VIEWS,
        PROCESSES_REPLACEMENTS,
        PROCESSES_RIGHTS,
        PROCESSES_FIELDS,
        PROCESSES_HEADER_FIELDS,
        SUBSTITUTIONS,
        RIGHTS,
        VIEWS_PRIVATE,
        VIEWS_PUBLIC,
        SCHEDULED_TASKS,
        CONFIG_TRANSLATIONS,
        CUSTOM_TRANSLATIONS,
        SYSTEM_TRANSLATIONS,
        PASSWORD_POLICIES,
        PASSWORD_GLOBAL_POLICY,
        ASSIGNED_PASSWORD_PROFILES,
        CALENDAR_RESOURCE_GROUPS,
        CALENDAR_RESOURCES,
        USER_CALENDARS,
        VIEW_CALENDARS,
        PROCESS_CALENDARS,
        EXTERNAL_CALENDARS,
        CALENDAR_SETS;

    }
}

