/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.configuration;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.configuration.SystemPropertiesBean;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomHolidaysHelper {
    public static final String EASTER_CUSTOM_HOLIDAY_PARAM_VALUE = "{EASTER}";
    private final SystemPropertiesBean systemPropertiesBean;

    @Autowired
    public CustomHolidaysHelper(SystemPropertiesBean systemPropertiesBean) {
        this.systemPropertiesBean = systemPropertiesBean;
    }

    public boolean areEasterBasedHolidaysSet() {
        String customHolidaysParam = this.systemPropertiesBean.getString(DefinedSystemParameter.CUSTOM_HOLIDAYS);
        return CustomHolidaysHelper.isEasterBasedHolidayPresent(customHolidaysParam);
    }

    public static boolean areEasterBasedHolidaysSetStatic() {
        String customHolidaysParam = SystemProperties.getString(DefinedSystemParameter.CUSTOM_HOLIDAYS);
        return CustomHolidaysHelper.isEasterBasedHolidayPresent(customHolidaysParam);
    }

    private static boolean isEasterBasedHolidayPresent(String customHolidaysParam) {
        if (StringUtils.isBlank((CharSequence)customHolidaysParam)) {
            return false;
        }
        return Arrays.stream(customHolidaysParam.split(";")).anyMatch(holiday -> holiday.equals(EASTER_CUSTOM_HOLIDAY_PARAM_VALUE));
    }
}

