/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.scheduledtask.context;

import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.administration.scheduledtask.context.ProgressHolder;
import com.suncode.pwfl.administration.scheduledtask.file.ScheduledTaskFileSaver;
import com.suncode.pwfl.core.context.Context;
import com.suncode.pwfl.core.context.ContextHolder;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class ScheduledTaskContext
implements Context {
    public static final String NAME = "scheduledtaskcontext";
    private final CancelationHandler handler;
    private final ProgressHolder progressHolder;
    private final Logger taskLogger;
    private final ScheduledTaskFileSaver fileSaver;
    private ScheduledTaskInstanceInfo scheduledTaskInfo;
    private static final ContextHolder<ScheduledTaskContext> holder = new ContextHolder("scheduledtaskcontext", true);

    protected ScheduledTaskContext(CancelationHandler cancelationHandler, Logger taskLogger, ScheduledTaskInstanceInfo scheduledTaskInfo, ScheduledTaskFileSaver fileSaver) {
        Assert.notNull((Object)cancelationHandler, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)taskLogger, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.scheduledTaskInfo = scheduledTaskInfo;
        this.handler = cancelationHandler;
        this.taskLogger = taskLogger;
        this.fileSaver = fileSaver;
        this.progressHolder = new ProgressHolder();
    }

    public static ScheduledTaskContext activate(CancelationHandler handler, Logger taskLogger, ScheduledTaskInstanceInfo scheduledTaskInfo, ScheduledTaskFileSaver fileSaver) {
        ScheduledTaskContext context = new ScheduledTaskContext(handler, taskLogger, scheduledTaskInfo, fileSaver);
        holder.activate(context);
        return context;
    }

    public static ScheduledTaskContext deactivate() {
        return holder.remove();
    }

    public static ScheduledTaskContext current() {
        return holder.current();
    }

    public static boolean isActive() {
        return holder.isActive();
    }

    public CancelationHandler getCancelationHandler() {
        return this.handler;
    }

    @Override
    public String name() {
        return NAME;
    }

    public ProgressHolder getProgressHolder() {
        return this.progressHolder;
    }

    public Logger getTaskLogger() {
        return this.taskLogger;
    }

    public ScheduledTaskFileSaver getFileSaver() {
        return this.fileSaver;
    }

    public ScheduledTaskInstanceInfo getScheduledTaskInfo() {
        return this.scheduledTaskInfo;
    }
}

