/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl;

import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.InMemoryCacheConfig;
import com.suncode.pwfl.cache.PlusWorkflowCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.xpdl.PackageCacheService;
import java.time.Duration;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.enhydra.shark.xpdl.elements.Package;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PackageCacheServiceImpl
implements PackageCacheService {
    @Autowired
    private CacheFactory cacheFactory;
    private PlusWorkflowCache<UUID, Package> packageCache;

    @PostConstruct
    private void init() {
        InMemoryCacheConfig cacheConfig = InMemoryCacheConfig.inMemoryBuilder().expireAfterWrite(Duration.ofMinutes(5L)).maximumSize(10L).build();
        this.packageCache = this.cacheFactory.createCache(SystemCacheId.PACKAGE_CACHE, cacheConfig);
    }

    @Override
    public void cache(UUID uuid, Package cache) {
        this.packageCache.put(uuid, cache);
    }

    @Override
    public Package get(UUID uuid) {
        return this.packageCache.getIfPresent(uuid);
    }
}

