/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.InMemoryCacheConfig;
import com.suncode.pwfl.cache.PlusWorkflowCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.util.SpringContext;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class CollatorInstance {
    private static final Logger log = LoggerFactory.getLogger(CollatorInstance.class);
    private static PlusWorkflowCache<Locale, Collator> collators;

    @PostConstruct
    private static void init() {
        if (collators == null) {
            CacheFactory cacheFactory = SpringContext.getBean(CacheFactory.class);
            InMemoryCacheConfig<Locale, Collator> cacheConfig = InMemoryCacheConfig.inMemoryBuilder().maximumSize(100L).loadFunction(CollatorInstance::getCollator).build();
            collators = cacheFactory.createCache(SystemCacheId.COLLATOR_CACHE, cacheConfig);
        }
    }

    public static Collator get() {
        CollatorInstance.init();
        Locale locale = LocaleContextHolder.getLocale();
        try {
            return collators.get(locale);
        }
        catch (ExecutionException e) {
            return CollatorInstance.getCollator(locale);
        }
    }

    private static Collator getCollator(Locale locale) {
        Collator collator = Collator.getInstance(locale);
        try {
            String rules = ((RuleBasedCollator)collator).getRules();
            rules = rules.replaceAll("<'_'", "<' '<'_'");
            return new RuleBasedCollator(rules);
        }
        catch (Exception e) {
            log.error("Could not change rule for collator with locale {}", (Object)LocaleContextHolder.getLocale().getLanguage());
            return collator;
        }
    }
}

