/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.cache;

import java.time.Duration;
import java.util.function.Function;

public class DefaultCacheConfig<K, V> {
    private final Long maximumSize;
    private final Duration expireAfterWrite;
    private final Function<? super K, ? extends V> loadFunction;

    protected DefaultCacheConfig(Long maximumSize, Duration expireAfterWrite, Function<? super K, ? extends V> loadFunction) {
        this.maximumSize = maximumSize;
        this.expireAfterWrite = expireAfterWrite;
        this.loadFunction = loadFunction;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public Long getMaximumSize() {
        return this.maximumSize;
    }

    public Duration getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public Function<? super K, ? extends V> getLoadFunction() {
        return this.loadFunction;
    }

    public static class Builder<K, V> {
        protected Long maximumSize;
        protected Duration expireAfterWrite;
        protected Function<? super K, ? extends V> loadFunction;

        public Builder<K, V> maximumSize(Long maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public Builder<K, V> expireAfterWrite(Duration duration) {
            this.expireAfterWrite = duration;
            return this;
        }

        public Builder<K, V> loadFunction(Function<? super K, ? extends V> loadFunction) {
            this.loadFunction = loadFunction;
            return this;
        }

        public DefaultCacheConfig<K, V> build() {
            return new DefaultCacheConfig<K, V>(this.maximumSize, this.expireAfterWrite, this.loadFunction);
        }
    }
}

