/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.cache;

import com.suncode.pwfl.cache.DefaultCacheConfig;
import com.suncode.pwfl.cache.Weigher;
import java.time.Duration;
import java.util.function.Function;

public class InMemoryCacheConfig<K, V>
extends DefaultCacheConfig<K, V> {
    private final Duration expireAfterRead;
    private final Long maximumWeight;
    private final Integer concurrencyLevel;
    private final Weigher<K, V> weigher;

    private InMemoryCacheConfig(Builder<K, V> builder) {
        super(builder.maximumSize, builder.expireAfterWrite, builder.loadFunction);
        this.expireAfterRead = builder.expireAfterRead;
        this.maximumWeight = builder.maximumWeight;
        this.concurrencyLevel = builder.concurrencyLevel;
        this.weigher = builder.weigher;
    }

    public static <K, V> Builder<K, V> inMemoryBuilder() {
        return new Builder();
    }

    public Duration getExpireAfterRead() {
        return this.expireAfterRead;
    }

    public Long getMaximumWeight() {
        return this.maximumWeight;
    }

    public Integer getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public Weigher<K, V> getWeigher() {
        return this.weigher;
    }

    public static class Builder<K, V> {
        private Long maximumSize;
        private Duration expireAfterWrite;
        private Function<K, V> loadFunction;
        private Duration expireAfterRead;
        private Long maximumWeight;
        private Integer concurrencyLevel;
        private Weigher<K, V> weigher;

        public Builder<K, V> maximumSize(Long maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public Builder<K, V> expireAfterWrite(Duration expireAfterWrite) {
            this.expireAfterWrite = expireAfterWrite;
            return this;
        }

        public Builder<K, V> loadFunction(Function<K, V> loadFunction) {
            this.loadFunction = loadFunction;
            return this;
        }

        public Builder<K, V> expireAfterRead(Duration expireAfterRead) {
            this.expireAfterRead = expireAfterRead;
            return this;
        }

        public Builder<K, V> maximumWeight(Long maximumWeight) {
            this.maximumWeight = maximumWeight;
            return this;
        }

        public Builder<K, V> concurrencyLevel(Integer concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<K, V> weigher(Weigher<K, V> weigher) {
            this.weigher = weigher;
            return this;
        }

        public InMemoryCacheConfig<K, V> build() {
            return new InMemoryCacheConfig(this);
        }
    }
}

