/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.datasource;

import com.google.common.collect.Maps;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceOperation;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDataSourceInstance
implements DataSourceInstance {
    private String dataSourceId;
    private DataSourceOperation operation;
    private String replaceSemicolonsChar;
    private boolean allowCache;
    private boolean supportsPagination;
    private Long cacheExpirationDelaySec;

    void setDataSourceIdIfEmpty(String dataSourceId) {
        if (StringUtils.isBlank((String)this.dataSourceId)) {
            this.dataSourceId = dataSourceId;
        }
    }

    void setDataSourceOperationIfEmpty(DataSourceOperation operation) {
        if (this.operation == null) {
            this.operation = operation;
        }
    }

    void setDataSourceReplaceSemicolonsCharIfEmpty(String replaceSemicolonsChar) {
        if (this.replaceSemicolonsChar == null) {
            this.replaceSemicolonsChar = replaceSemicolonsChar;
        }
    }

    protected void setDataSourceAllowCacheIfEmpty(Boolean allowCache) {
        this.allowCache = allowCache;
    }

    protected void setSupportsPagination(Boolean supportsPagination) {
        this.supportsPagination = supportsPagination;
    }

    protected void setDataSourceCacheExpireDelayIfEmpty(Long cacheExpirationDelaySec) {
        if (this.cacheExpirationDelaySec == null) {
            this.cacheExpirationDelaySec = cacheExpirationDelaySec;
        }
    }

    @Override
    public CountedResult<Map<String, Object>> execute(Map<String, String> parameters, Pagination pagination) {
        return this.execute(parameters, new HashMap<String, String>(), pagination);
    }

    @Override
    public CountedResult<Map<String, Object>> execute(Map<String, String> parameters, Map<String, String> filters, Pagination pagination) {
        switch (this.operation) {
            case READ: {
                return this.getCountedData(parameters, filters, pagination);
            }
            case INSERT: {
                this.save(Maps.newLinkedHashMap(parameters));
                break;
            }
            case UPDATE: {
                this.update(Maps.newLinkedHashMap(parameters));
                break;
            }
            case DELETE: {
                this.delete(Maps.newLinkedHashMap(parameters));
            }
        }
        return new CountedResult<Map<String, Object>>(0L, new ArrayList());
    }

    @Override
    @Deprecated(since="4.2")
    public CountedResult<Map<String, Object>> getCountedData(Map<String, String> parameters, Pagination pagination) {
        return this.getCountedData(parameters, Maps.newHashMap(), pagination);
    }

    @Override
    @Deprecated(since="4.2")
    public CountedResult<Map<String, Object>> getCountedData(Map<String, String> parameters, Map<String, String> filters, Pagination pagination) {
        return null;
    }

    @Override
    @Deprecated(since="4.2")
    public void save(Map<String, Object> data) {
    }

    @Override
    @Deprecated(since="4.2")
    public void update(Map<String, Object> data) {
    }

    @Override
    @Deprecated(since="4.2")
    public void delete(Map<String, Object> data) {
    }

    @Override
    public abstract Set<DataSourceParameter> getInputParameters();

    @Override
    public abstract Set<DataSourceParameter> getOutputParameters();

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public DataSourceOperation getOperation() {
        return this.operation;
    }

    public String getReplaceSemicolonsChar() {
        return this.replaceSemicolonsChar;
    }

    public boolean isAllowCache() {
        return this.allowCache;
    }

    public boolean isSupportsPagination() {
        return this.supportsPagination;
    }

    public Long getCacheExpirationDelaySec() {
        return this.cacheExpirationDelaySec;
    }
}

