/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.workflow.activity.ActivityDocument;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="pm_files")
@SequenceGenerator(name="files_id_seq", sequenceName="files_id_seq")
public class WfFile {
    public static final String JOIN_DOC_CLASS = "documentClass";
    public static final String JOIN_VERSION = "version";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="files_id_seq")
    private long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="docclassid", nullable=false)
    private DocumentClass documentClass;
    private String description;
    private boolean compressed;
    private boolean encrypted;
    private String cipherAlgorithm;
    private String cipherKey;
    @Column(name="org_name")
    private String fileName;
    @Column(name="name")
    private String systemFileName;
    @Column(name="file_date")
    private Date fileDate;
    private String path;
    private String uploader;
    @Column(name="file_size")
    private long size;
    @Column(name="one_drive_item_id")
    private String oneDriveItemId;
    @Column(name="google_drive_file_id")
    private String googleDriveFileId;
    private UUID guid;
    @Fetch(value=FetchMode.JOIN)
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="file")
    private WfFileVersion version;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="file")
    private Set<ActivityDocument> activityDocuments;

    public WfFile(Long id) {
        this.id = id;
    }

    public WfFile(long id, String fileName) {
        this.id = id;
        this.fileName = fileName;
    }

    @Transient
    public String getFullPath() {
        return FilenameUtils.normalize((String)(this.getPath() + "/" + this.getSystemFileName()));
    }

    public void addActivityDocument(ActivityDocument activityDocument) {
        if (this.activityDocuments == null) {
            this.activityDocuments = new HashSet<ActivityDocument>();
        }
        this.activityDocuments.add(activityDocument);
    }

    public long getId() {
        return this.id;
    }

    public DocumentClass getDocumentClass() {
        return this.documentClass;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public String getCipherKey() {
        return this.cipherKey;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSystemFileName() {
        return this.systemFileName;
    }

    public Date getFileDate() {
        return this.fileDate;
    }

    public String getPath() {
        return this.path;
    }

    public String getUploader() {
        return this.uploader;
    }

    public long getSize() {
        return this.size;
    }

    public String getOneDriveItemId() {
        return this.oneDriveItemId;
    }

    public String getGoogleDriveFileId() {
        return this.googleDriveFileId;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public WfFileVersion getVersion() {
        return this.version;
    }

    public Set<ActivityDocument> getActivityDocuments() {
        return this.activityDocuments;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setDocumentClass(DocumentClass documentClass) {
        this.documentClass = documentClass;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public void setCipherKey(String cipherKey) {
        this.cipherKey = cipherKey;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSystemFileName(String systemFileName) {
        this.systemFileName = systemFileName;
    }

    public void setFileDate(Date fileDate) {
        this.fileDate = fileDate;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUploader(String uploader) {
        this.uploader = uploader;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setOneDriveItemId(String oneDriveItemId) {
        this.oneDriveItemId = oneDriveItemId;
    }

    public void setGoogleDriveFileId(String googleDriveFileId) {
        this.googleDriveFileId = googleDriveFileId;
    }

    public void setGuid(UUID guid) {
        this.guid = guid;
    }

    public void setVersion(WfFileVersion version) {
        this.version = version;
    }

    public void setActivityDocuments(Set<ActivityDocument> activityDocuments) {
        this.activityDocuments = activityDocuments;
    }

    public WfFile() {
    }
}

