/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component;

import com.suncode.pwfl.component.exception.ConditionException;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Types;
import org.springframework.util.Assert;

public class Condition {
    private final FunctionCall conditionFn;

    public Condition(FunctionCall conditionFn) {
        Assert.notNull((Object)conditionFn, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.isTrue((boolean)conditionFn.getReturnType().equals(Types.BOOLEAN), (String)"[Assertion failed] - this expression must be true");
        this.conditionFn = conditionFn;
    }

    public FunctionCall getConditionFn() {
        return this.conditionFn;
    }

    public boolean isFulfilled() {
        try {
            return (Boolean)this.conditionFn.call();
        }
        catch (Exception e) {
            throw new ConditionException(this.conditionFn.getFunction(), e.getMessage(), (Throwable)e);
        }
    }
}

