/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.security.extraverifiers;

import com.suncode.pwfl.security.extraverifiers.AuthenticationParameters;
import com.suncode.pwfl.security.extraverifiers.ExtraAuthVerifierValueProvider;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ExtraAuthVerifier {
    private static final Logger log = Logger.getLogger(ExtraAuthVerifier.class);
    private ExtraAuthVerifierValueProvider firstValueProvider;
    private ExtraAuthVerifierValueProvider secondValueProvider;
    private boolean ignoreCase;

    public boolean isValid(AuthenticationParameters authenticationParameters) {
        String firstValue = this.firstValueProvider.getValueToCompare(authenticationParameters);
        String secondValue = this.secondValueProvider.getValueToCompare(authenticationParameters);
        if (firstValue == null && secondValue == null) {
            log.warn((Object)"Both extra auth verifier values are null");
            return false;
        }
        return this.ignoreCase ? StringUtils.equalsIgnoreCase((CharSequence)firstValue, (CharSequence)secondValue) : StringUtils.equals((CharSequence)firstValue, (CharSequence)secondValue);
    }

    @ConstructorProperties(value={"firstValueProvider", "secondValueProvider", "ignoreCase"})
    public ExtraAuthVerifier(ExtraAuthVerifierValueProvider firstValueProvider, ExtraAuthVerifierValueProvider secondValueProvider, boolean ignoreCase) {
        this.firstValueProvider = firstValueProvider;
        this.secondValueProvider = secondValueProvider;
        this.ignoreCase = ignoreCase;
    }

    public ExtraAuthVerifierValueProvider getFirstValueProvider() {
        return this.firstValueProvider;
    }

    public ExtraAuthVerifierValueProvider getSecondValueProvider() {
        return this.secondValueProvider;
    }
}

