/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.security;

import com.suncode.pwfl.security.CustomRedirectHelper;
import com.suncode.pwfl.security.CustomRedirectType;
import com.suncode.pwfl.util.SpringContext;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.i18n.LocaleContextHolder;

public class CustomRedirectInfo {
    public static String DEFAULT_LOCALE_KEY = "default";
    private CustomRedirectType redirectType;
    private Map<String, String> localizedValue;

    public CustomRedirectInfo(CustomRedirectType redirectType, Map<String, String> localizedValue) {
        CustomRedirectHelper customRedirectHelper = SpringContext.getBean(CustomRedirectHelper.class);
        this.redirectType = redirectType;
        this.localizedValue = localizedValue.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), entry -> customRedirectHelper.sanitizeRedirectHtml((String)entry.getValue())));
    }

    public String getValue() {
        String locale = LocaleContextHolder.getLocale().toString().toLowerCase();
        return this.localizedValue.getOrDefault(locale, this.localizedValue.get(DEFAULT_LOCALE_KEY));
    }

    public CustomRedirectType getRedirectType() {
        return this.redirectType;
    }

    public Map<String, String> getLocalizedValue() {
        return this.localizedValue;
    }
}

