/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.systemMessage;

import com.suncode.pwfl.administration.systemMessage.SystemMessageReadHistory;
import com.suncode.pwfl.administration.systemMessage.SystemMessageType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Set;

@Entity
@Table(name="pm_system_message")
@SequenceGenerator(name="pm_system_message_id_seq", sequenceName="pm_system_message_id_seq")
public class SystemMessage {
    public static final String JOIN_READS_HISTORY = "readsHistory";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_system_message_id_seq")
    private Long id;
    @Column(length=4000)
    private String message;
    @Column(name="message_type")
    @Enumerated(value=EnumType.STRING)
    private SystemMessageType messageType;
    private Date startDate;
    private Date finishDate;
    private String groupId;
    private boolean enabled;
    private boolean afterLogin;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="systemMessage")
    private Set<SystemMessageReadHistory> readsHistory;

    public static SystemMessageBuilder builder() {
        return new SystemMessageBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public SystemMessageType getMessageType() {
        return this.messageType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getFinishDate() {
        return this.finishDate;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAfterLogin() {
        return this.afterLogin;
    }

    public Set<SystemMessageReadHistory> getReadsHistory() {
        return this.readsHistory;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessageType(SystemMessageType messageType) {
        this.messageType = messageType;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAfterLogin(boolean afterLogin) {
        this.afterLogin = afterLogin;
    }

    public void setReadsHistory(Set<SystemMessageReadHistory> readsHistory) {
        this.readsHistory = readsHistory;
    }

    public SystemMessage() {
    }

    @ConstructorProperties(value={"id", "message", "messageType", "startDate", "finishDate", "groupId", "enabled", "afterLogin", "readsHistory"})
    public SystemMessage(Long id, String message, SystemMessageType messageType, Date startDate, Date finishDate, String groupId, boolean enabled, boolean afterLogin, Set<SystemMessageReadHistory> readsHistory) {
        this.id = id;
        this.message = message;
        this.messageType = messageType;
        this.startDate = startDate;
        this.finishDate = finishDate;
        this.groupId = groupId;
        this.enabled = enabled;
        this.afterLogin = afterLogin;
        this.readsHistory = readsHistory;
    }

    public static class SystemMessageBuilder {
        private Long id;
        private String message;
        private SystemMessageType messageType;
        private Date startDate;
        private Date finishDate;
        private String groupId;
        private boolean enabled;
        private boolean afterLogin;
        private Set<SystemMessageReadHistory> readsHistory;

        SystemMessageBuilder() {
        }

        public SystemMessageBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public SystemMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        public SystemMessageBuilder messageType(SystemMessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public SystemMessageBuilder startDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public SystemMessageBuilder finishDate(Date finishDate) {
            this.finishDate = finishDate;
            return this;
        }

        public SystemMessageBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public SystemMessageBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public SystemMessageBuilder afterLogin(boolean afterLogin) {
            this.afterLogin = afterLogin;
            return this;
        }

        public SystemMessageBuilder readsHistory(Set<SystemMessageReadHistory> readsHistory) {
            this.readsHistory = readsHistory;
            return this;
        }

        public SystemMessage build() {
            return new SystemMessage(this.id, this.message, this.messageType, this.startDate, this.finishDate, this.groupId, this.enabled, this.afterLogin, this.readsHistory);
        }

        public String toString() {
            return "SystemMessage.SystemMessageBuilder(id=" + this.id + ", message=" + this.message + ", messageType=" + this.messageType + ", startDate=" + this.startDate + ", finishDate=" + this.finishDate + ", groupId=" + this.groupId + ", enabled=" + this.enabled + ", afterLogin=" + this.afterLogin + ", readsHistory=" + this.readsHistory + ")";
        }
    }
}

