/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.google.common.collect.Maps;
import com.suncode.pwfl.core.type.Type;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class TypeBase<T>
implements Type<T> {
    private static final Logger log = LoggerFactory.getLogger(TypeBase.class);
    private final Class<T> javaType;
    private final T defaultValue;
    private final Map<Class<?>, Convert<?, T>> aliases = Maps.newHashMap();
    private final Map<Class<?>, Convert<?, T>> converters = Maps.newHashMap();
    private boolean forceInstanceWhenReading = true;

    public TypeBase(Class<T> javaType, T defaultValue) {
        Assert.notNull(javaType);
        this.javaType = javaType;
        this.defaultValue = defaultValue;
    }

    @Deprecated(since="4.2", forRemoval=true)
    protected void setForceInstanceWhenReading(boolean forceInstanceWhenReading) {
        this.forceInstanceWhenReading = forceInstanceWhenReading;
    }

    @Deprecated(since="4.2", forRemoval=true)
    protected boolean isForceInstanceWhenReading() {
        return this.forceInstanceWhenReading;
    }

    @Override
    public Class<T> javaType() {
        return this.javaType;
    }

    @Override
    public T defaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isInstance(Object value) {
        return value == null || this.isInstance(value.getClass());
    }

    protected <S> void aliasType(Class<S> type, Convert<S, T> aliased) {
        this.aliases.put(type, aliased);
    }

    protected <S> void converter(Class<S> type, Convert<S, T> convertFn) {
        this.converters.put(type, convertFn);
    }

    @Override
    public boolean isInstance(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (this.isAssignable(type, this.javaType)) {
            return true;
        }
        for (Class<?> alias : this.aliases.keySet()) {
            if (!this.isAssignable(type, alias)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAssignable(Class<?> source, Class<?> target) {
        return this.resolve(target).isAssignableFrom(this.resolve(source));
    }

    @Override
    public T read(Object value) {
        return this.readAs(value, this.javaType);
    }

    @Override
    public <I, O> O readAs(I value, Class<O> type) {
        if (value == null) {
            return null;
        }
        Class<?> in = this.resolve(value.getClass());
        Class<O> out = this.resolve(type);
        if (out.isAssignableFrom(in)) {
            return (O)value;
        }
        return this.doReadAs(value, in, out);
    }

    protected <I, O> O doReadAs(I value, Class<I> in, Class<O> out) {
        try {
            Convert<I, T> source = this.converter(in).orElseThrow(this.noConverterFound(value, in));
            Convert<O, T> target = this.converter(out).orElseThrow(this.noConverterFound(value, out));
            return target.fromBase(source.toBase(value));
        }
        catch (Exception e) {
            try {
                O result = this.doReadAsLegacy(value, in, out);
                log.error("New conversion failed but legacy conversion did not: {} -> {}", new Object[]{value, result, e});
                return result;
            }
            catch (Exception legacy) {
                e.addSuppressed(legacy);
                throw e;
            }
        }
    }

    private <I> Optional<Convert<I, T>> converter(Class<I> targetType) {
        if (this.javaType.isAssignableFrom(targetType)) {
            return Optional.of(Convert.identity());
        }
        return Optional.ofNullable(this.aliases.getOrDefault(targetType, this.converters.get(targetType)));
    }

    private Supplier<RuntimeException> noConverterFound(Object value, Class<?> target) {
        return () -> {
            throw new IllegalArgumentException(String.format("No converter found for %s [type=%s, value=%s]", target, this, value));
        };
    }

    private Class<?> resolve(Class<?> clazz) {
        return ClassUtils.resolvePrimitiveIfNecessary(clazz);
    }

    @Deprecated(since="4.2", forRemoval=true)
    private <I, O> O doReadAsLegacy(I value, Class<I> in, Class<O> out) {
        Convert<?, T> source = this.aliases.get(in);
        Convert<?, Object> target = this.aliases.get(out);
        if (this.javaType.isAssignableFrom(out)) {
            return (O)source.toBase(value);
        }
        if (this.javaType.isAssignableFrom(in)) {
            return (O)target.fromBase(value);
        }
        return (O)target.fromBase(source.toBase(value));
    }

    public String toString() {
        return this.name();
    }

    @Override
    public abstract T convert(String var1);

    public static interface Convert<A, T> {
        public A fromBase(T var1);

        public T toBase(A var1);

        public static <V> Convert<V, V> identity() {
            return new Convert<V, V>(){

                @Override
                public V fromBase(V value) {
                    return value;
                }

                @Override
                public V toBase(V value) {
                    return value;
                }
            };
        }
    }
}

