/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component;

import com.suncode.pwfl.component.Validations;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.core.type.support.JsonSerializable;
import com.suncode.pwfl.translation.LocalizedString;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;

public class ParameterDefinition<T> {
    private final String id;
    private final LocalizedString name;
    private final LocalizedString description;
    private final Type<T> type;
    private final boolean optional;
    private final T defaultValue;
    private final Validations validations;
    private final List<String> recommendedFunctions;

    public ParameterDefinition(String id, Type<T> type) {
        this(id, type, null, null, false, null);
    }

    public ParameterDefinition(String id, Type<T> type, LocalizedString name, LocalizedString description, boolean optional, T defaultValue) {
        this(id, type, name, description, optional, defaultValue, null, null);
    }

    public ParameterDefinition(String id, Type<T> type, LocalizedString name, LocalizedString description, boolean optional, T defaultValue, List<String> recommendedFunctions) {
        this(id, type, name, description, optional, defaultValue, null, recommendedFunctions);
    }

    public ParameterDefinition(String id, Type<T> type, LocalizedString name, LocalizedString description, boolean optional, T defaultValue, Validations validations, List<String> recommendedFunctions) {
        Assert.hasText((String)id);
        Assert.notNull(type);
        this.id = id;
        this.type = type;
        this.name = name;
        this.description = description;
        this.optional = optional;
        this.defaultValue = type.read(defaultValue);
        this.recommendedFunctions = new ArrayList<String>();
        if (recommendedFunctions != null) {
            this.recommendedFunctions.addAll(recommendedFunctions);
        }
        if (this.defaultValue != null && !(type instanceof JsonSerializable)) {
            throw new IllegalStateException("Parameter [" + this + "] type has default value but cannot be serialized to JSON.");
        }
        this.validations = validations == null ? Validations.noValidation() : validations;
        this.validations.validateParameterType(type, this.defaultValue);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name != null ? this.name.getOptional() : this.id;
    }

    public String getDescription() {
        return this.description != null ? this.description.getOptional() : null;
    }

    public Type<?> getType() {
        return this.type;
    }

    public boolean isArray() {
        return Types.isArray(this.type);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public List<String> getRecommendedFunctions() {
        return this.recommendedFunctions;
    }

    public Validations getValidations() {
        return this.validations;
    }

    public String toString() {
        return this.id + "(" + this.type + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition other = (ParameterDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Type<?> this$type = this.getType();
        Type<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        T this$defaultValue = this.getDefaultValue();
        T other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        Validations this$validations = this.getValidations();
        Validations other$validations = other.getValidations();
        if (this$validations == null ? other$validations != null : !this$validations.equals(other$validations)) {
            return false;
        }
        List<String> this$recommendedFunctions = this.getRecommendedFunctions();
        List<String> other$recommendedFunctions = other.getRecommendedFunctions();
        return !(this$recommendedFunctions == null ? other$recommendedFunctions != null : !((Object)this$recommendedFunctions).equals(other$recommendedFunctions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOptional() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Type<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        T $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        Validations $validations = this.getValidations();
        result = result * 59 + ($validations == null ? 43 : $validations.hashCode());
        List<String> $recommendedFunctions = this.getRecommendedFunctions();
        result = result * 59 + ($recommendedFunctions == null ? 43 : ((Object)$recommendedFunctions).hashCode());
        return result;
    }
}

