/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.suncode.pwfl.archive.DocumentClassIndex;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;

@Entity
@Table(name="pm_indexpattern")
@SequenceGenerator(name="pm_indexpattern_seq", sequenceName="pm_indexpattern_seq")
public class IndexPattern {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_indexpattern_seq")
    private Long id;
    @Column(nullable=false)
    private String pattern;
    @Column(nullable=false)
    private String replacement;
    @Column(nullable=false)
    private Boolean isRegex;
    @JsonIgnore
    @JoinColumn(name="documentindexid")
    @ManyToOne(fetch=FetchType.LAZY)
    private DocumentClassIndex index;

    public static IndexPatternBuilder builder() {
        return new IndexPatternBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public Boolean getIsRegex() {
        return this.isRegex;
    }

    public DocumentClassIndex getIndex() {
        return this.index;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public void setIsRegex(Boolean isRegex) {
        this.isRegex = isRegex;
    }

    @JsonIgnore
    public void setIndex(DocumentClassIndex index) {
        this.index = index;
    }

    public IndexPattern() {
    }

    @ConstructorProperties(value={"id", "pattern", "replacement", "isRegex", "index"})
    public IndexPattern(Long id, String pattern, String replacement, Boolean isRegex, DocumentClassIndex index) {
        this.id = id;
        this.pattern = pattern;
        this.replacement = replacement;
        this.isRegex = isRegex;
        this.index = index;
    }

    public static class IndexPatternBuilder {
        private Long id;
        private String pattern;
        private String replacement;
        private Boolean isRegex;
        private DocumentClassIndex index;

        IndexPatternBuilder() {
        }

        public IndexPatternBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public IndexPatternBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public IndexPatternBuilder replacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        public IndexPatternBuilder isRegex(Boolean isRegex) {
            this.isRegex = isRegex;
            return this;
        }

        @JsonIgnore
        public IndexPatternBuilder index(DocumentClassIndex index) {
            this.index = index;
            return this;
        }

        public IndexPattern build() {
            return new IndexPattern(this.id, this.pattern, this.replacement, this.isRegex, this.index);
        }

        public String toString() {
            return "IndexPattern.IndexPatternBuilder(id=" + this.id + ", pattern=" + this.pattern + ", replacement=" + this.replacement + ", isRegex=" + this.isRegex + ", index=" + this.index + ")";
        }
    }
}

