/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.context;

import com.suncode.pwfl.core.context.Context;
import com.suncode.pwfl.core.context.ContextNotActiveException;
import com.suncode.pwfl.core.context.InContext;
import com.suncode.pwfl.core.context.InContextReturning;
import java.util.Stack;
import org.springframework.util.Assert;

public class ContextHolder<T extends Context> {
    private final String contextName;
    private final boolean single;
    private final ThreadLocal<Stack<T>> context = new ThreadLocal<Stack<T>>(){

        @Override
        protected Stack<T> initialValue() {
            return new Stack();
        }
    };

    public ContextHolder(String contextName) {
        this(contextName, false);
    }

    public ContextHolder(String contextName, boolean single) {
        Assert.hasText((String)contextName);
        this.contextName = contextName;
        this.single = single;
    }

    public boolean isActive() {
        return !this.context.get().isEmpty();
    }

    public T current() throws ContextNotActiveException {
        this.ensureActive();
        return (T)((Context)this.context.get().peek());
    }

    public void activate(T newContext) {
        Assert.notNull(newContext);
        if (this.single && this.isActive()) {
            throw new IllegalStateException("Only one [" + this.contextName + "] context can be active.");
        }
        this.context.get().push(newContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(T newContext, InContext<T> action) {
        Assert.notNull(action);
        try {
            this.activate(newContext);
            action.doInContext(newContext);
        }
        finally {
            T current = this.current();
            if (current != newContext) {
                throw new IllegalStateException("Invalid active context: expected [" + newContext + "::" + System.identityHashCode(newContext) + "] but found [" + current + "::" + System.identityHashCode(current) + "]. Always clear context in try/finally block!");
            }
            this.context.get().pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R activateReturning(T newContext, InContextReturning<T, ? extends R> action) {
        Assert.notNull(action);
        try {
            this.activate(newContext);
            R r = action.doInContext(newContext);
            return r;
        }
        finally {
            T current = this.current();
            if (current != newContext) {
                throw new IllegalStateException("Invalid active context: expected [" + newContext + "::" + System.identityHashCode(newContext) + "] but found [" + current + "::" + System.identityHashCode(current) + "]. Always clear context in try/finally block!");
            }
            this.context.get().pop();
        }
    }

    public T remove() throws ContextNotActiveException {
        this.ensureActive();
        return (T)((Context)this.context.get().pop());
    }

    private void ensureActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException(this.contextName);
        }
    }
}

