/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.google.common.collect.Lists;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class UserInfo {
    private String userName;
    private String firstName;
    private String lastName;
    private String fullName;
    private String email;
    private String number;
    private List<GroupInfo> groups;
    private List<PositionInfo> positions;
    private boolean isAnonymous;

    public UserInfo(User user) {
        this(user, true);
    }

    public UserInfo(User user, boolean expanded) {
        this.userName = user.getUserName();
        this.firstName = this.def(user.getFirstName());
        this.lastName = this.def(user.getLastName());
        this.fullName = StringUtils.trim((String)(this.firstName + " " + this.lastName));
        this.email = this.def(user.getEmail());
        this.number = this.def(user.getNumber());
        this.isAnonymous = user.isAnonymous();
        if (expanded) {
            this.groups = Lists.newArrayList();
            this.positions = Lists.newArrayList();
            for (UserGroup group : user.getGroups()) {
                this.groups.add(new GroupInfo(group));
            }
            for (Position position : user.getPositions()) {
                this.positions.add(new PositionInfo(position));
            }
        }
    }

    public static UserInfo of(User user, boolean expanded) {
        return user != null ? new UserInfo(user, expanded) : null;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getNumber() {
        return this.number;
    }

    public List<GroupInfo> getGroups() {
        return this.groups;
    }

    public List<PositionInfo> getPositions() {
        return this.positions;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    private String def(String value) {
        return value != null ? value : "";
    }

    public String getInitials() {
        String displayName = StringUtils.isNotBlank((String)this.fullName) ? this.fullName : this.userName;
        return Arrays.stream(displayName.split("\\s+", -1)).filter(StringUtils::isNotBlank).limit(2L).map(word -> word.substring(0, 1)).collect(Collectors.joining()).toUpperCase();
    }

    public static class GroupInfo {
        private String name;

        public GroupInfo(UserGroup group) {
            this.name = group.getName();
        }

        public String getName() {
            return this.name;
        }
    }

    public static class PositionInfo
    extends Resource {
        private UnitInfo unit;
        private UserInfo user;
        private PositionInfo higherPosition;

        public PositionInfo(Position position) {
            this(position, true);
        }

        public PositionInfo(Position position, boolean expanded) {
            super(position.getName(), position.getSymbol());
            this.user = UserInfo.of(position.getUser(), false);
            if (expanded) {
                this.unit = UnitInfo.of(position.getOrganizationalUnit());
                this.higherPosition = PositionInfo.of(position.getHigherPosition(), false);
            }
        }

        public static PositionInfo of(Position position, boolean expanded) {
            return position != null ? new PositionInfo(position, expanded) : null;
        }

        public UserInfo getUser() {
            return this.user;
        }

        public UnitInfo getUnit() {
            return this.unit;
        }

        public PositionInfo getHigherPosition() {
            return this.higherPosition;
        }
    }

    public static class Resource {
        private String name;
        private String symbol;

        public Resource(String name, String symbol) {
            this.name = name;
            this.symbol = symbol;
        }

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }

    public static class UnitInfo
    extends Resource {
        public UnitInfo(OrganizationalUnit unit) {
            super(unit.getName(), unit.getSymbol());
        }

        public static UnitInfo of(OrganizationalUnit unit) {
            return unit != null ? new UnitInfo(unit) : null;
        }
    }
}

