/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.translation.configElements.LinkIndexTranslation;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;

@Entity
@Table(name="pm_linkindecies")
@SequenceGenerator(name="pm_linkindecies_id_seq", sequenceName="pm_linkindecies_id_seq")
public class LinkIndex {
    public static final String JOIN_LINK = "link";
    public static final String JOIN_TRANSLATIONS = "translations";
    public static final String NAME_COLUMN_NAME = "indexname";
    public static final String DESC_COLUMN_NAME = "indexdescription";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_linkindecies_id_seq")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="linkid")
    private Link link;
    @OneToMany(mappedBy="linkIndex", cascade={CascadeType.ALL})
    private Set<LinkConnection> connections;
    @Column(name="indexname")
    private String name;
    @Column(name="indexdescription")
    private String description;
    @Column(name="indextype")
    private String type;
    @Column(name="indexvalues", length=4000)
    private String values;
    @Column(name="indexorder")
    private Long order;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="translatedEntity", cascade={CascadeType.REMOVE})
    private List<LinkIndexTranslation> translations;

    public String getIndexTypeName() {
        switch (this.type) {
            case "integer": {
                return MessageHelper.getMessage((String)"Calkowity");
            }
            case "float": {
                return MessageHelper.getMessage((String)"Zmiennoprzecinkowy");
            }
            case "string": {
                return MessageHelper.getMessage((String)"Tekstowy");
            }
            case "date": {
                return MessageHelper.getMessage((String)"Data");
            }
            case "list": {
                return MessageHelper.getMessage((String)"Lista_wartosci");
            }
            case "dateTime": {
                return MessageHelper.getMessage((String)"Data_i_czas");
            }
            case "boolean": {
                return MessageHelper.getMessage((String)"IndexType.boolean");
            }
        }
        return this.type;
    }

    public static LinkIndexBuilder builder() {
        return new LinkIndexBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Link getLink() {
        return this.link;
    }

    public Set<LinkConnection> getConnections() {
        return this.connections;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getValues() {
        return this.values;
    }

    public Long getOrder() {
        return this.order;
    }

    public List<LinkIndexTranslation> getTranslations() {
        return this.translations;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    public void setConnections(Set<LinkConnection> connections) {
        this.connections = connections;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValues(String values) {
        this.values = values;
    }

    public void setOrder(Long order) {
        this.order = order;
    }

    public void setTranslations(List<LinkIndexTranslation> translations) {
        this.translations = translations;
    }

    public LinkIndex() {
    }

    @ConstructorProperties(value={"id", "link", "connections", "name", "description", "type", "values", "order", "translations"})
    public LinkIndex(Long id, Link link, Set<LinkConnection> connections, String name, String description, String type, String values, Long order, List<LinkIndexTranslation> translations) {
        this.id = id;
        this.link = link;
        this.connections = connections;
        this.name = name;
        this.description = description;
        this.type = type;
        this.values = values;
        this.order = order;
        this.translations = translations;
    }

    public static class LinkIndexBuilder {
        private Long id;
        private Link link;
        private Set<LinkConnection> connections;
        private String name;
        private String description;
        private String type;
        private String values;
        private Long order;
        private List<LinkIndexTranslation> translations;

        LinkIndexBuilder() {
        }

        public LinkIndexBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public LinkIndexBuilder link(Link link) {
            this.link = link;
            return this;
        }

        public LinkIndexBuilder connections(Set<LinkConnection> connections) {
            this.connections = connections;
            return this;
        }

        public LinkIndexBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LinkIndexBuilder description(String description) {
            this.description = description;
            return this;
        }

        public LinkIndexBuilder type(String type) {
            this.type = type;
            return this;
        }

        public LinkIndexBuilder values(String values) {
            this.values = values;
            return this;
        }

        public LinkIndexBuilder order(Long order) {
            this.order = order;
            return this;
        }

        public LinkIndexBuilder translations(List<LinkIndexTranslation> translations) {
            this.translations = translations;
            return this;
        }

        public LinkIndex build() {
            return new LinkIndex(this.id, this.link, this.connections, this.name, this.description, this.type, this.values, this.order, this.translations);
        }

        public String toString() {
            return "LinkIndex.LinkIndexBuilder(id=" + this.id + ", link=" + this.link + ", connections=" + this.connections + ", name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", values=" + this.values + ", order=" + this.order + ", translations=" + this.translations + ")";
        }
    }
}

