/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.database;

import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.substitution.Substitution;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDateTime;

public class UserDelegationsTable {
    private Long id;
    private Long parentId;
    private String sProcesId;
    private String sParticipantId;
    private String sUser;
    private String sDelegatedUser;
    private Long lStartDate;
    private Long lFinishDate;
    private String isActive;

    public UserDelegationsTable(Long parentId, String procesId, String participantId, String user, String delegatedUser, Long startDate, Long finishDate, String isActive) {
        this.sProcesId = procesId;
        this.sParticipantId = participantId;
        this.sUser = user;
        this.sDelegatedUser = delegatedUser;
        this.lStartDate = startDate;
        this.lFinishDate = finishDate;
        this.isActive = isActive;
        this.parentId = parentId;
    }

    public UserDelegationsTable() {
    }

    public String getSDelegatedUser() {
        return this.sDelegatedUser;
    }

    public void setSDelegatedUser(String delegatedUser) {
        this.sDelegatedUser = delegatedUser;
    }

    public String getSUser() {
        return this.sUser;
    }

    public void setSUser(String user) {
        this.sUser = user;
    }

    public String getSParticipantId() {
        return this.sParticipantId;
    }

    public void setSParticipantId(String participantId) {
        this.sParticipantId = participantId;
    }

    public String getSProcesId() {
        return this.sProcesId;
    }

    public void setSProcesId(String procesId) {
        this.sProcesId = procesId;
    }

    public String getIsActive() {
        return this.isActive;
    }

    public void setIsActive(String isActive) {
        this.isActive = isActive;
    }

    public Long getLFinishDate() {
        return this.lFinishDate;
    }

    public void setLFinishDate(Long finishDate) {
        this.lFinishDate = finishDate;
    }

    public Long getLStartDate() {
        return this.lStartDate;
    }

    public void setLStartDate(Long startDate) {
        this.lStartDate = startDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Substitution convertToSubstitution() {
        UserService us = ServiceFactory.getUserService();
        Substitution substitution = new Substitution();
        if (StringUtils.isNotBlank((String)this.sProcesId) && !StringUtils.equals((String)this.sProcesId, (String)"*")) {
            substitution.setProcessDefId(this.sProcesId);
        }
        if (StringUtils.isNotBlank((String)this.sParticipantId) && !StringUtils.equals((String)this.sParticipantId, (String)"*")) {
            RoleService rs = ServiceFactory.getRoleService();
            ProcessService ps = ServiceFactory.getProcessService();
            ProcessDefinition pd = ps.getProcessDefinition(this.sProcesId);
            Role role = rs.getRole(pd.getPackageId(), pd.getProcessDefinitionId(), this.sParticipantId);
            substitution.setRole(role);
        }
        substitution.setSubstituted(us.getUser(this.sUser, new String[0]));
        substitution.setSubstitute(us.getUser(this.sDelegatedUser, new String[0]));
        if (this.lStartDate != null && this.lStartDate > 0L) {
            substitution.setStartDate(new LocalDateTime((Object)this.lStartDate));
        }
        if (this.lFinishDate != null && this.lFinishDate > 0L) {
            substitution.setFinishDate(new LocalDateTime((Object)this.lFinishDate));
        }
        return substitution;
    }

    public static UserDelegationsTable convertToDelegation(Substitution substitution) {
        UserDelegationsTable udt = new UserDelegationsTable();
        udt.setId(substitution.getId());
        udt.setParentId(null);
        udt.setLFinishDate(substitution.getFinishDate().toDate().getTime());
        udt.setLStartDate(substitution.getStartDate().toDate().getTime());
        udt.setIsActive("true");
        udt.setSDelegatedUser(substitution.getSubstitute().getUserName());
        Role role = substitution.getRole();
        if (role != null) {
            udt.setSParticipantId(role.getRoleId());
        } else {
            udt.setSParticipantId("*");
        }
        String processDefId = substitution.getProcessDefId();
        if (StringUtils.isNotBlank((String)processDefId)) {
            udt.setSProcesId(processDefId);
        } else {
            udt.setSProcesId("*");
        }
        udt.setSUser(substitution.getSubstituted().getUserName());
        return udt;
    }
}

