/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.suncode.pwfl.core.data.Record;
import com.suncode.pwfl.core.type.ArrayType;
import com.suncode.pwfl.core.type.BasicTypes;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.xpdl.table.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class TableStore {
    private final Map<String, BasicTypes> variableType;
    private final List<Record> data = new ArrayList<Record>();

    public TableStore(@NonNull Map<String, BasicTypes> variableType, @NonNull List<Record> data) {
        if (variableType == null) {
            throw new NullPointerException("variableType is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.variableType = ImmutableMap.copyOf(variableType);
        data.forEach(this::add);
    }

    public TableStore(Table table, Map<String, Variable> activityContextMapVariables) {
        List<Variable> variableList = table.getColumns().stream().map(column -> (Variable)activityContextMapVariables.get(column.getVarId())).collect(Collectors.toList());
        this.variableType = variableList.stream().collect(Collectors.toMap(Variable::getId, variable -> BasicTypes.wrap(((ArrayType)variable.getType()).getElementType())));
        int amountOfRows = this.getAmountOfRowsInTable(variableList);
        for (int i = 0; i < amountOfRows; ++i) {
            Record recordToAdd = new Record();
            for (Variable variable2 : variableList) {
                recordToAdd.put(variable2.getId(), Arrays.asList((Object[])variable2.getValue()).get(i));
            }
            this.add(recordToAdd);
        }
    }

    public TableStore add(Record record) {
        Sets.SetView extraFields = Sets.difference(record.getFieldNames(), this.variableType.keySet());
        if (!extraFields.isEmpty()) {
            throw new IllegalArgumentException("Extra fields found in record not found in schema: known=" + this.variableType.keySet() + " extra=" + extraFields);
        }
        Record toAdd = new Record();
        this.variableType.forEach((field, typeFromSchema) -> {
            if (!record.hasField((String)field)) {
                toAdd.put((String)field, typeFromSchema.getType().defaultValue());
            } else {
                toAdd.put((String)field, typeFromSchema.getType().read(record.get((String)field)));
            }
        });
        this.data.add(toAdd);
        return this;
    }

    public List<Record> getData() {
        return ImmutableList.copyOf(this.data);
    }

    public void setData(List<Record> data) {
        this.data.clear();
        for (Record singleRecord : data) {
            this.add(singleRecord);
        }
    }

    public static TableStore fromJson(String json) {
        return Types.TABLE_STORE.convert(json);
    }

    public String toJson() {
        return Types.TABLE_STORE.readAs(this, String.class);
    }

    public static TableStore empty() {
        return new TableStore(Collections.emptyMap(), Collections.emptyList());
    }

    private int getAmountOfRowsInTable(List<Variable> columnVariables) {
        int amountOfRows = Arrays.asList((Object[])columnVariables.get(0).getValue()).size();
        if (amountOfRows == 1) {
            boolean isTableEmpty = columnVariables.stream().allMatch(variable -> {
                Object[] value = (Object[])variable.getValue();
                if (value instanceof String[]) {
                    return StringUtils.isEmpty((CharSequence)((String)value[0]));
                }
                return value[0] == null;
            });
            return isTableEmpty ? 0 : 1;
        }
        return amountOfRows;
    }

    public static TableStoreBuilder builder() {
        return new TableStoreBuilder();
    }

    public TableStoreBuilder toBuilder() {
        TableStoreBuilder builder = new TableStoreBuilder();
        if (this.variableType != null) {
            builder.variableType(this.variableType);
        }
        if (this.data != null) {
            builder.data(this.data);
        }
        return builder;
    }

    public Map<String, BasicTypes> getVariableType() {
        return this.variableType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableStore)) {
            return false;
        }
        TableStore other = (TableStore)o;
        Map<String, BasicTypes> this$variableType = this.getVariableType();
        Map<String, BasicTypes> other$variableType = other.getVariableType();
        if (this$variableType == null ? other$variableType != null : !((Object)this$variableType).equals(other$variableType)) {
            return false;
        }
        List<Record> this$data = this.getData();
        List<Record> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, BasicTypes> $variableType = this.getVariableType();
        result = result * 59 + ($variableType == null ? 43 : ((Object)$variableType).hashCode());
        List<Record> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "TableStore(variableType=" + this.getVariableType() + ", data=" + this.getData() + ")";
    }

    public static class TableStoreBuilder {
        private ArrayList<String> variableType$key;
        private ArrayList<BasicTypes> variableType$value;
        private ArrayList<Record> data;

        TableStoreBuilder() {
        }

        public TableStoreBuilder fieldType(String fieldTypeKey, BasicTypes fieldTypeValue) {
            if (this.variableType$key == null) {
                this.variableType$key = new ArrayList();
                this.variableType$value = new ArrayList();
            }
            this.variableType$key.add(fieldTypeKey);
            this.variableType$value.add(fieldTypeValue);
            return this;
        }

        public TableStoreBuilder variableType(Map<? extends String, ? extends BasicTypes> variableType) {
            if (variableType == null) {
                throw new NullPointerException("variableType cannot be null");
            }
            if (this.variableType$key == null) {
                this.variableType$key = new ArrayList();
                this.variableType$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends BasicTypes> $lombokEntry : variableType.entrySet()) {
                this.variableType$key.add($lombokEntry.getKey());
                this.variableType$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public TableStoreBuilder clearVariableType() {
            if (this.variableType$key != null) {
                this.variableType$key.clear();
                this.variableType$value.clear();
            }
            return this;
        }

        public TableStoreBuilder record(Record record) {
            if (this.data == null) {
                this.data = new ArrayList();
            }
            this.data.add(record);
            return this;
        }

        public TableStoreBuilder data(Collection<? extends Record> data) {
            if (data == null) {
                throw new NullPointerException("data cannot be null");
            }
            if (this.data == null) {
                this.data = new ArrayList();
            }
            this.data.addAll(data);
            return this;
        }

        public TableStoreBuilder clearData() {
            if (this.data != null) {
                this.data.clear();
            }
            return this;
        }

        public TableStore build() {
            Map<String, BasicTypes> variableType;
            switch (this.variableType$key == null ? 0 : this.variableType$key.size()) {
                case 0: {
                    variableType = Collections.emptyMap();
                    break;
                }
                case 1: {
                    variableType = Collections.singletonMap(this.variableType$key.get(0), this.variableType$value.get(0));
                    break;
                }
                default: {
                    variableType = new LinkedHashMap(this.variableType$key.size() < 0x40000000 ? 1 + this.variableType$key.size() + (this.variableType$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.variableType$key.size(); ++$i) {
                        variableType.put(this.variableType$key.get($i), this.variableType$value.get($i));
                    }
                    variableType = Collections.unmodifiableMap(variableType);
                }
            }
            return new TableStore(variableType, switch (this.data == null ? 0 : this.data.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.data.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Record>(this.data));
            });
        }

        public String toString() {
            return "TableStore.TableStoreBuilder(variableType$key=" + this.variableType$key + ", variableType$value=" + this.variableType$value + ", data=" + this.data + ")";
        }
    }
}

