/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component;

import com.suncode.pwfl.component.exception.InvalidComponentException;
import com.suncode.pwfl.core.type.ArrayType;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.beans.ConstructorProperties;
import javax.annotation.Nullable;

public final class Validations {
    @Nullable
    private final Integer arrayMinLength;
    private static final Validations NO_VALIDATION = Validations.builder().build();

    public static Validations noValidation() {
        return NO_VALIDATION;
    }

    public <T> void validateParameterType(Type<T> type, @Nullable T defaultValue) {
        if (this.arrayMinLength != null) {
            if (!Types.isArray(type)) {
                throw new InvalidComponentException("`arrayMinLength` validation cannot be applied to non-array type: got " + type);
            }
            if (defaultValue != null) {
                Object[] array = (Object[])((ArrayType)type).read(defaultValue);
                this.validateValue(array);
            }
        }
    }

    <T> void validateValue(T[] values) {
        if (this.arrayMinLength != null && values.length < this.arrayMinLength) {
            throw new InvalidComponentException(String.format("Validation error: expected `arrayMinLength`=%s got %s", this.arrayMinLength, values.length));
        }
    }

    @ConstructorProperties(value={"arrayMinLength"})
    Validations(@Nullable Integer arrayMinLength) {
        this.arrayMinLength = arrayMinLength;
    }

    public static ValidationsBuilder builder() {
        return new ValidationsBuilder();
    }

    @Nullable
    public Integer getArrayMinLength() {
        return this.arrayMinLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Validations)) {
            return false;
        }
        Validations other = (Validations)o;
        Integer this$arrayMinLength = this.getArrayMinLength();
        Integer other$arrayMinLength = other.getArrayMinLength();
        return !(this$arrayMinLength == null ? other$arrayMinLength != null : !((Object)this$arrayMinLength).equals(other$arrayMinLength));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $arrayMinLength = this.getArrayMinLength();
        result = result * 59 + ($arrayMinLength == null ? 43 : ((Object)$arrayMinLength).hashCode());
        return result;
    }

    public String toString() {
        return "Validations(arrayMinLength=" + this.getArrayMinLength() + ")";
    }

    public static class ValidationsBuilder {
        private Integer arrayMinLength;

        ValidationsBuilder() {
        }

        public ValidationsBuilder arrayMinLength(@Nullable Integer arrayMinLength) {
            this.arrayMinLength = arrayMinLength;
            return this;
        }

        public Validations build() {
            return new Validations(this.arrayMinLength);
        }

        public String toString() {
            return "Validations.ValidationsBuilder(arrayMinLength=" + this.arrayMinLength + ")";
        }
    }
}

