/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.util.Exceptions;
import jakarta.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class SystemContext {
    private static SystemContext instance;
    private ServletContext servletContext;
    private String contextUrl;

    private SystemContext(ServletContext servletContext) {
        Assert.notNull((Object)servletContext);
        this.servletContext = servletContext;
        this.contextUrl = servletContext.getContextPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(ServletContext servletContext) {
        if (instance != null) return;
        Class<SystemContext> clazz = SystemContext.class;
        synchronized (SystemContext.class) {
            if (instance != null) return;
            instance = new SystemContext(servletContext);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static SystemContext get() {
        return instance;
    }

    public String getBaseUrl() {
        String baseUrl;
        String httpLinkParameter = SystemProperties.getString(DefinedSystemParameter.HTTPLINK);
        String string = baseUrl = httpLinkParameter.endsWith("/") ? httpLinkParameter.replaceAll("/+$", "") : httpLinkParameter;
        if (StringUtils.isBlank((String)baseUrl)) {
            baseUrl = Exceptions.silent(() -> ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString(), () -> "");
        }
        return this.normalizePath(baseUrl);
    }

    private String normalizePath(String path) {
        if (StringUtils.isNotBlank((String)path) && path.endsWith("/")) {
            return StringUtils.chop((String)path);
        }
        return path;
    }

    public String getAbsolutePath(String relativePath) {
        return this.getBaseUrl() + "/" + relativePath;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getContextUrl() {
        return this.contextUrl;
    }
}

