/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.authentication.googleApi;

import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.administration.configuration.exception.DecryptingException;
import com.suncode.pwfl.administration.configuration.exception.EncryptingException;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="pm_google_api_auth")
public class GoogleApiAuthentication {
    @Id
    private String id;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false)
    private String type;
    @Column(nullable=false)
    private String projectId;
    @Column(nullable=false)
    private String privateKeyId;
    @Column(nullable=false)
    private String privateKey;
    @Column(nullable=false)
    private String clientEmail;
    @Column(nullable=false)
    private String clientId;
    @Column(nullable=false)
    private String authUri;
    @Column(nullable=false)
    private String tokenUri;
    @Column(nullable=false)
    private String authProviderX509CertUrl;
    @Column(nullable=false)
    private String clientX509CertUrl;
    @Column(nullable=false)
    private String universeDomain;

    public String getDecryptedPrivateKey() {
        return GoogleApiAuthentication.decryptPrivateKey(this.privateKey);
    }

    public void setEncryptedPrivateKey(String privateKey) {
        this.privateKey = GoogleApiAuthentication.encryptPrivateKey(privateKey);
    }

    private static String decryptPrivateKey(String encryptedPrivateKey) {
        if (StringUtils.isBlank((CharSequence)encryptedPrivateKey)) {
            return encryptedPrivateKey;
        }
        try {
            return TextCipher.decrypt(encryptedPrivateKey);
        }
        catch (Exception e) {
            throw new DecryptingException("Failed to decrypt", e);
        }
    }

    private static String encryptPrivateKey(String privateKey) {
        if (StringUtils.isBlank((CharSequence)privateKey)) {
            return privateKey;
        }
        try {
            return TextCipher.encrypt(privateKey);
        }
        catch (Exception e) {
            throw new EncryptingException("Failed to encrypt", e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getPrivateKeyId() {
        return this.privateKeyId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getClientEmail() {
        return this.clientEmail;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getAuthUri() {
        return this.authUri;
    }

    public String getTokenUri() {
        return this.tokenUri;
    }

    public String getAuthProviderX509CertUrl() {
        return this.authProviderX509CertUrl;
    }

    public String getClientX509CertUrl() {
        return this.clientX509CertUrl;
    }

    public String getUniverseDomain() {
        return this.universeDomain;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setPrivateKeyId(String privateKeyId) {
        this.privateKeyId = privateKeyId;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setClientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setAuthUri(String authUri) {
        this.authUri = authUri;
    }

    public void setTokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
    }

    public void setAuthProviderX509CertUrl(String authProviderX509CertUrl) {
        this.authProviderX509CertUrl = authProviderX509CertUrl;
    }

    public void setClientX509CertUrl(String clientX509CertUrl) {
        this.clientX509CertUrl = clientX509CertUrl;
    }

    public void setUniverseDomain(String universeDomain) {
        this.universeDomain = universeDomain;
    }

    public GoogleApiAuthentication() {
    }

    @ConstructorProperties(value={"id", "name", "type", "projectId", "privateKeyId", "privateKey", "clientEmail", "clientId", "authUri", "tokenUri", "authProviderX509CertUrl", "clientX509CertUrl", "universeDomain"})
    public GoogleApiAuthentication(String id, String name, String type, String projectId, String privateKeyId, String privateKey, String clientEmail, String clientId, String authUri, String tokenUri, String authProviderX509CertUrl, String clientX509CertUrl, String universeDomain) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.projectId = projectId;
        this.privateKeyId = privateKeyId;
        this.privateKey = privateKey;
        this.clientEmail = clientEmail;
        this.clientId = clientId;
        this.authUri = authUri;
        this.tokenUri = tokenUri;
        this.authProviderX509CertUrl = authProviderX509CertUrl;
        this.clientX509CertUrl = clientX509CertUrl;
        this.universeDomain = universeDomain;
    }

    public static class Builder {
        private String id;
        private String name;
        private String type;
        private String projectId;
        private String privateKeyId;
        private String privateKey;
        private String clientEmail;
        private String clientId;
        private String authUri;
        private String tokenUri;
        private String authProviderX509CertUrl;
        private String clientX509CertUrl;
        private String universeDomain;

        public Builder encryptedPrivateKey(String privateKey) {
            this.privateKey = GoogleApiAuthentication.encryptPrivateKey(privateKey);
            return this;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder privateKeyId(String privateKeyId) {
            this.privateKeyId = privateKeyId;
            return this;
        }

        public Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder clientEmail(String clientEmail) {
            this.clientEmail = clientEmail;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder authUri(String authUri) {
            this.authUri = authUri;
            return this;
        }

        public Builder tokenUri(String tokenUri) {
            this.tokenUri = tokenUri;
            return this;
        }

        public Builder authProviderX509CertUrl(String authProviderX509CertUrl) {
            this.authProviderX509CertUrl = authProviderX509CertUrl;
            return this;
        }

        public Builder clientX509CertUrl(String clientX509CertUrl) {
            this.clientX509CertUrl = clientX509CertUrl;
            return this;
        }

        public Builder universeDomain(String universeDomain) {
            this.universeDomain = universeDomain;
            return this;
        }

        public GoogleApiAuthentication build() {
            return new GoogleApiAuthentication(this.id, this.name, this.type, this.projectId, this.privateKeyId, this.privateKey, this.clientEmail, this.clientId, this.authUri, this.tokenUri, this.authProviderX509CertUrl, this.clientX509CertUrl, this.universeDomain);
        }

        public String toString() {
            return "GoogleApiAuthentication.Builder(id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", projectId=" + this.projectId + ", privateKeyId=" + this.privateKeyId + ", privateKey=" + this.privateKey + ", clientEmail=" + this.clientEmail + ", clientId=" + this.clientId + ", authUri=" + this.authUri + ", tokenUri=" + this.tokenUri + ", authProviderX509CertUrl=" + this.authProviderX509CertUrl + ", clientX509CertUrl=" + this.clientX509CertUrl + ", universeDomain=" + this.universeDomain + ")";
        }
    }
}

