/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.workflow.activity.ActivityDocument;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="pm_files")
@SequenceGenerator(name="files_id_seq", sequenceName="files_id_seq")
public class WfFile {
    public static final String JOIN_DOC_CLASS = "documentClass";
    public static final String JOIN_VERSION = "version";
    private long id;
    private DocumentClass documentClass;
    private String description;
    private boolean compressed;
    private boolean encrypted;
    private String cipherAlgorithm;
    private String cipherKey;
    private String fileName;
    private String systemFileName;
    private Date fileDate;
    private String path;
    private String uploader;
    private long size;
    private String oneDriveItemId;
    private WfFileVersion version;
    private Set<ActivityDocument> activityDocuments;

    public WfFile(Long id) {
        this.id = id;
    }

    public WfFile(long id, String fileName) {
        this.id = id;
        this.fileName = fileName;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="files_id_seq")
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public String getCipherKey() {
        return this.cipherKey;
    }

    public void setCipherKey(String cipherKey) {
        this.cipherKey = cipherKey;
    }

    @Column(name="org_name")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Column(name="name")
    public String getSystemFileName() {
        return this.systemFileName;
    }

    public void setSystemFileName(String systemFileName) {
        this.systemFileName = systemFileName;
    }

    @Column(name="file_date")
    public Date getFileDate() {
        return this.fileDate;
    }

    public void setFileDate(Date fileDate) {
        this.fileDate = fileDate;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUploader() {
        return this.uploader;
    }

    public void setUploader(String uploader) {
        this.uploader = uploader;
    }

    @Column(name="file_size")
    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Column(name="one_drive_item_id")
    public String getOneDriveItemId() {
        return this.oneDriveItemId;
    }

    public void setOneDriveItemId(String oneDriveItemId) {
        this.oneDriveItemId = oneDriveItemId;
    }

    @Fetch(value=FetchMode.JOIN)
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="file")
    public WfFileVersion getVersion() {
        return this.version;
    }

    public void setVersion(WfFileVersion version) {
        this.version = version;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="docclassid", nullable=false)
    public DocumentClass getDocumentClass() {
        return this.documentClass;
    }

    public void setDocumentClass(DocumentClass documentClass) {
        this.documentClass = documentClass;
    }

    @Transient
    public String getFullPath() {
        return FilenameUtils.normalize((String)(this.getPath() + "/" + this.getSystemFileName()));
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="file")
    public Set<ActivityDocument> getActivityDocuments() {
        return this.activityDocuments;
    }

    public void setActivityDocuments(Set<ActivityDocument> activityDocuments) {
        this.activityDocuments = activityDocuments;
    }

    public void addActivityDocument(ActivityDocument activityDocument) {
        if (this.activityDocuments == null) {
            this.activityDocuments = new HashSet<ActivityDocument>();
        }
        this.activityDocuments.add(activityDocument);
    }

    public WfFile() {
    }
}

