/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.ui;

import com.google.common.collect.Maps;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.pwfl.web.ui.ScriptInjection;
import com.suncode.pwfl.web.ui.UIFragment;
import java.util.concurrent.ConcurrentMap;
import org.springframework.core.io.Resource;

@Provides(value={WebScripts.class})
public interface WebScripts {
    public static final String FRAGMENTS_URL_PREFIX = "/resources/fragments";

    public void initFragment(String var1);

    public ScriptInjection inject(UIFragment var1, Resource var2);

    public ScriptInjection inject(String var1, Resource var2);

    public static class Link {
        public static String fragment(UIFragment fragment) {
            return Link.fragment(fragment.id(), false);
        }

        public static String fragment(UIFragment fragment, boolean debug) {
            return Link.fragment(fragment.id(), debug);
        }

        public static String fragment(String fragment, boolean debug) {
            return "/resources/fragments/" + fragment + ".js?" + UrlCacheParameter.get().value(fragment) + (debug ? "&debug" : "");
        }
    }

    public static class UrlCacheParameter {
        private static UrlCacheParameter instance = new UrlCacheParameter();
        private ConcurrentMap<String, Long> cacheParameters = Maps.newConcurrentMap();

        public static UrlCacheParameter get() {
            return instance;
        }

        public void invalidate(String fragmentId) {
            this.cacheParameters.remove(fragmentId);
        }

        public String value(String fragmentId) {
            Long newValue = System.currentTimeMillis();
            Long value = this.cacheParameters.putIfAbsent(fragmentId, newValue);
            if (value == null) {
                value = newValue;
            }
            return "_dc=" + value;
        }
    }
}

