/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.authentication.microsoftGraphApi;

import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.administration.configuration.exception.DecryptingException;
import com.suncode.pwfl.administration.configuration.exception.EncryptingException;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="pm_ms_graph_api_auth")
public class MicrosoftGraphApiAuthentication {
    @Id
    private String id;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false, length=1024)
    private String userId;
    @Column(nullable=false, length=1024)
    private String clientId;
    @Column(nullable=false, length=1024)
    private String tenantId;
    @Column(nullable=false, length=2048)
    private String clientSecret;

    public String getDecryptedClientSecret() {
        return MicrosoftGraphApiAuthentication.decryptClientSecret(this.clientSecret);
    }

    public void setEncryptedClientSecret(String clientSecret) {
        this.clientSecret = MicrosoftGraphApiAuthentication.encryptClientSecret(clientSecret);
    }

    private static String decryptClientSecret(String encryptedClientSecret) {
        if (StringUtils.isEmpty((CharSequence)encryptedClientSecret)) {
            return encryptedClientSecret;
        }
        try {
            return TextCipher.decrypt(encryptedClientSecret);
        }
        catch (Exception e) {
            throw new DecryptingException();
        }
    }

    private static String encryptClientSecret(String clientSecret) {
        if (StringUtils.isEmpty((CharSequence)clientSecret)) {
            return clientSecret;
        }
        try {
            return TextCipher.encrypt(clientSecret);
        }
        catch (Exception e) {
            throw new EncryptingException();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public MicrosoftGraphApiAuthentication() {
    }

    @ConstructorProperties(value={"id", "name", "userId", "clientId", "tenantId", "clientSecret"})
    public MicrosoftGraphApiAuthentication(String id, String name, String userId, String clientId, String tenantId, String clientSecret) {
        this.id = id;
        this.name = name;
        this.userId = userId;
        this.clientId = clientId;
        this.tenantId = tenantId;
        this.clientSecret = clientSecret;
    }

    public static class Builder {
        private String id;
        private String name;
        private String userId;
        private String clientId;
        private String tenantId;
        private String clientSecret;

        public Builder encryptedClientSecret(String clientSecret) {
            this.clientSecret = MicrosoftGraphApiAuthentication.encryptClientSecret(clientSecret);
            return this;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public MicrosoftGraphApiAuthentication build() {
            return new MicrosoftGraphApiAuthentication(this.id, this.name, this.userId, this.clientId, this.tenantId, this.clientSecret);
        }

        public String toString() {
            return "MicrosoftGraphApiAuthentication.Builder(id=" + this.id + ", name=" + this.name + ", userId=" + this.userId + ", clientId=" + this.clientId + ", tenantId=" + this.tenantId + ", clientSecret=" + this.clientSecret + ")";
        }
    }
}

