/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.application.onedrive;

import com.suncode.pwfl.administration.authentication.microsoftGraphApi.MicrosoftGraphApiAuthentication;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;

@Entity
@Table(name="pm_one_drive_app")
public class OneDriveApplication {
    public static final String JOIN_AUTHENTICATION = "authentication";
    @Id
    private String id;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false)
    private Boolean defaultConfiguration;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="authenticationid", nullable=false)
    private MicrosoftGraphApiAuthentication authentication;
    @Column(nullable=false, length=1024)
    private String directoryName;

    public static OneDriveApplicationBuilder builder() {
        return new OneDriveApplicationBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public MicrosoftGraphApiAuthentication getAuthentication() {
        return this.authentication;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefaultConfiguration(Boolean defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void setAuthentication(MicrosoftGraphApiAuthentication authentication) {
        this.authentication = authentication;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public OneDriveApplication() {
    }

    @ConstructorProperties(value={"id", "name", "defaultConfiguration", "authentication", "directoryName"})
    public OneDriveApplication(String id, String name, Boolean defaultConfiguration, MicrosoftGraphApiAuthentication authentication, String directoryName) {
        this.id = id;
        this.name = name;
        this.defaultConfiguration = defaultConfiguration;
        this.authentication = authentication;
        this.directoryName = directoryName;
    }

    public static class OneDriveApplicationBuilder {
        private String id;
        private String name;
        private Boolean defaultConfiguration;
        private MicrosoftGraphApiAuthentication authentication;
        private String directoryName;

        OneDriveApplicationBuilder() {
        }

        public OneDriveApplicationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public OneDriveApplicationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OneDriveApplicationBuilder defaultConfiguration(Boolean defaultConfiguration) {
            this.defaultConfiguration = defaultConfiguration;
            return this;
        }

        public OneDriveApplicationBuilder authentication(MicrosoftGraphApiAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public OneDriveApplicationBuilder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public OneDriveApplication build() {
            return new OneDriveApplication(this.id, this.name, this.defaultConfiguration, this.authentication, this.directoryName);
        }

        public String toString() {
            return "OneDriveApplication.OneDriveApplicationBuilder(id=" + this.id + ", name=" + this.name + ", defaultConfiguration=" + this.defaultConfiguration + ", authentication=" + this.authentication + ", directoryName=" + this.directoryName + ")";
        }
    }
}

