/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.util.ServiceFactory;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.beans.ConstructorProperties;
import java.util.Set;

@Entity
@Table(name="pm_directories")
@SequenceGenerator(name="pm_directories_id_seq", sequenceName="pm_directories_id_seq")
public class Directory {
    public static final String JOIN_DOC_CLASSES = "docClasses";
    public static final String JOIN_DEVICE = "device";
    public static final String JOIN_ROOT_DIR = "rootDir";
    private Long id;
    private Directory rootDir;
    private Device device;
    private String directoryName;
    private Long directorySize;
    private Long directoryThreshold;
    private Long directoryFreeSpace;
    private Set<DocumentClass> docClasses;

    public Directory(Long id) {
        this.id = id;
    }

    public Directory() {
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_directories_id_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rootdirectoryid")
    public Directory getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(Directory rootDir) {
        this.rootDir = rootDir;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="deviceid")
    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String name) {
        this.directoryName = name;
    }

    public Long getDirectorySize() {
        return this.directorySize;
    }

    public void setDirectorySize(Long size) {
        this.directorySize = size;
    }

    public Long getDirectoryThreshold() {
        return this.directoryThreshold;
    }

    public void setDirectoryThreshold(Long treshold) {
        this.directoryThreshold = treshold;
    }

    public Long getDirectoryFreeSpace() {
        return this.directoryFreeSpace;
    }

    public void setDirectoryFreeSpace(Long freeSpace) {
        this.directoryFreeSpace = freeSpace;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="directory")
    public Set<DocumentClass> getDocClasses() {
        return this.docClasses;
    }

    public void setDocClasses(Set<DocumentClass> docClasses) {
        this.docClasses = docClasses;
    }

    @Transient
    @JsonIgnore
    public Long getTrueDirectoryFreeSpace() {
        ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
        this.directoryFreeSpace = as.getDirectoryFreeSpaceFromDB(this);
        return this.directoryFreeSpace;
    }

    public static DirectoryBuilder builder() {
        return new DirectoryBuilder();
    }

    @ConstructorProperties(value={"id", "rootDir", "device", "directoryName", "directorySize", "directoryThreshold", "directoryFreeSpace", "docClasses"})
    public Directory(Long id, Directory rootDir, Device device, String directoryName, Long directorySize, Long directoryThreshold, Long directoryFreeSpace, Set<DocumentClass> docClasses) {
        this.id = id;
        this.rootDir = rootDir;
        this.device = device;
        this.directoryName = directoryName;
        this.directorySize = directorySize;
        this.directoryThreshold = directoryThreshold;
        this.directoryFreeSpace = directoryFreeSpace;
        this.docClasses = docClasses;
    }

    public static class DirectoryBuilder {
        private Long id;
        private Directory rootDir;
        private Device device;
        private String directoryName;
        private Long directorySize;
        private Long directoryThreshold;
        private Long directoryFreeSpace;
        private Set<DocumentClass> docClasses;

        DirectoryBuilder() {
        }

        public DirectoryBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public DirectoryBuilder rootDir(Directory rootDir) {
            this.rootDir = rootDir;
            return this;
        }

        public DirectoryBuilder device(Device device) {
            this.device = device;
            return this;
        }

        public DirectoryBuilder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public DirectoryBuilder directorySize(Long directorySize) {
            this.directorySize = directorySize;
            return this;
        }

        public DirectoryBuilder directoryThreshold(Long directoryThreshold) {
            this.directoryThreshold = directoryThreshold;
            return this;
        }

        public DirectoryBuilder directoryFreeSpace(Long directoryFreeSpace) {
            this.directoryFreeSpace = directoryFreeSpace;
            return this;
        }

        public DirectoryBuilder docClasses(Set<DocumentClass> docClasses) {
            this.docClasses = docClasses;
            return this;
        }

        public Directory build() {
            return new Directory(this.id, this.rootDir, this.device, this.directoryName, this.directorySize, this.directoryThreshold, this.directoryFreeSpace, this.docClasses);
        }

        public String toString() {
            return "Directory.DirectoryBuilder(id=" + this.id + ", rootDir=" + this.rootDir + ", device=" + this.device + ", directoryName=" + this.directoryName + ", directorySize=" + this.directorySize + ", directoryThreshold=" + this.directoryThreshold + ", directoryFreeSpace=" + this.directoryFreeSpace + ", docClasses=" + this.docClasses + ")";
        }
    }
}

