/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class SessionUtils {
    private static String UNKNOWN_USER_NAME = "UNKNOWN";

    private static RequestAttributes getCurrentRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            throw new IllegalStateException("Current thread is not bound to HttpRequest");
        }
        return attributes;
    }

    public static jakarta.servlet.http.HttpServletRequest getCurrentRequest() {
        RequestAttributes requestAttributes = SessionUtils.getCurrentRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        return null;
    }

    public static HttpSession getCurrentSession() {
        HttpServletRequest request = (HttpServletRequest)SessionUtils.getCurrentRequest();
        if (request == null) {
            throw new IllegalStateException("Current thread is not bound to HttpRequest");
        }
        return request.getSession(false);
    }

    public static Object getSessionAttribute(String name) {
        return SessionUtils.getCurrentRequestAttributes().getAttribute(name, 1);
    }

    public static String getLoggedUserNameOrUnknown() {
        String userName = UNKNOWN_USER_NAME;
        try {
            String sessionUserName = SessionUtils.getLoggedUserName();
            if (StringUtils.isNotBlank((String)sessionUserName)) {
                userName = sessionUserName;
                return userName;
            }
        }
        finally {
            return userName;
        }
    }

    public static String getLoggedUserName() {
        return (String)SessionUtils.getSessionAttribute("username");
    }

    public static String getLoggedUserDomain() {
        return (String)SessionUtils.getSessionAttribute("domain");
    }

    @Deprecated
    public static String getLoggedUserPassword() {
        return "";
    }
}

