/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component.support;

import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.component.support.ParameterBinder;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class InvocableMethod {
    static boolean USE_IMPLICIT_PLUGIN_CONTEXT_CLASS_LOADER = false;
    private final Method method;
    private final MethodParameter[] parameters;

    public InvocableMethod(Method method) {
        Assert.notNull((Object)method);
        this.method = method;
        int parameterCount = method.getParameterTypes().length;
        this.parameters = new MethodParameter[parameterCount];
        DefaultParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();
        for (int i = 0; i < parameterCount; ++i) {
            MethodParameter parameter = new MethodParameter(method, i);
            parameter.initParameterNameDiscovery((ParameterNameDiscoverer)discoverer);
            this.parameters[i] = parameter;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    public Class<?> getParameterClass(int index) {
        return this.parameters[index].getParameterType();
    }

    public Annotation getParameterAnnotation(int index, Class<? extends Annotation> annotationType) {
        return this.parameters[index].getParameterAnnotation(annotationType);
    }

    public boolean hasParameterAnnotation(int index, Class<? extends Annotation> annotationType) {
        return this.parameters[index].hasParameterAnnotation(annotationType);
    }

    public String getParameterName(int index) {
        Param annotation;
        MethodParameter param = this.parameters[index];
        if (param.hasParameterAnnotation(Param.class) && StringUtils.hasText((String)(annotation = (Param)param.getParameterAnnotation(Param.class)).value())) {
            return annotation.value();
        }
        return param.getParameterName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object instance, ParameterBinder ... binders) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] invokeArgs = new Object[this.getParameterCount()];
        for (int i = 0; i < this.getParameterCount(); ++i) {
            invokeArgs[i] = this.bind(this.parameters[i], i, binders);
        }
        if (!this.method.isAccessible()) {
            this.method.setAccessible(true);
        }
        if (USE_IMPLICIT_PLUGIN_CONTEXT_CLASS_LOADER) {
            ClassLoader previousContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.method.getDeclaringClass().getClassLoader());
                Object object = this.method.invoke(instance, invokeArgs);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousContextClassLoader);
            }
        }
        return this.method.invoke(instance, invokeArgs);
    }

    private Object bind(MethodParameter parameter, int index, ParameterBinder[] binders) {
        Class clazz = parameter.getParameterType();
        for (ParameterBinder binder : binders) {
            if (!binder.shouldBind(index, clazz, this)) continue;
            return binder.bind(index, clazz, this);
        }
        throw new IllegalArgumentException("Couldn't bind parameter #" + (index + 1) + " of method [" + this + "]. No matching binder found.");
    }

    public String toString() {
        return this.method.toString();
    }
}

