/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.configuration;

import com.suncode.pwfl.administration.configuration.SystemParameter;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;
import lombok.NonNull;

@Entity
@Table(name="pm_systemparametercombovalues")
@SequenceGenerator(name="pm_combovalues_seq", sequenceName="pm_combovalues_seq")
public class ComboValue {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_combovalues_seq")
    private Long id;
    @JoinColumn(name="ownerid", nullable=false)
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @NonNull
    private SystemParameter systemParameter;
    @NonNull
    private String value;

    public static ComboValueBuilder builder() {
        return new ComboValueBuilder();
    }

    public Long getId() {
        return this.id;
    }

    @NonNull
    public SystemParameter getSystemParameter() {
        return this.systemParameter;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSystemParameter(@NonNull SystemParameter systemParameter) {
        if (systemParameter == null) {
            throw new NullPointerException("systemParameter is marked non-null but is null");
        }
        this.systemParameter = systemParameter;
    }

    public void setValue(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    public ComboValue() {
    }

    @ConstructorProperties(value={"id", "systemParameter", "value"})
    public ComboValue(Long id, @NonNull SystemParameter systemParameter, @NonNull String value) {
        if (systemParameter == null) {
            throw new NullPointerException("systemParameter is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.id = id;
        this.systemParameter = systemParameter;
        this.value = value;
    }

    @ConstructorProperties(value={"systemParameter", "value"})
    public ComboValue(@NonNull SystemParameter systemParameter, @NonNull String value) {
        if (systemParameter == null) {
            throw new NullPointerException("systemParameter is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.systemParameter = systemParameter;
        this.value = value;
    }

    public static class ComboValueBuilder {
        private Long id;
        private SystemParameter systemParameter;
        private String value;

        ComboValueBuilder() {
        }

        public ComboValueBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ComboValueBuilder systemParameter(@NonNull SystemParameter systemParameter) {
            if (systemParameter == null) {
                throw new NullPointerException("systemParameter is marked non-null but is null");
            }
            this.systemParameter = systemParameter;
            return this;
        }

        public ComboValueBuilder value(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            return this;
        }

        public ComboValue build() {
            return new ComboValue(this.id, this.systemParameter, this.value);
        }

        public String toString() {
            return "ComboValue.ComboValueBuilder(id=" + this.id + ", systemParameter=" + this.systemParameter + ", value=" + this.value + ")";
        }
    }
}

