/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.authentication.basic;

import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.administration.configuration.exception.DecryptingException;
import com.suncode.pwfl.administration.configuration.exception.EncryptingException;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="pm_basic_auth_config")
public class BasicAuthenticationConfiguration {
    @Id
    private String id;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false)
    private String username;
    @Column(nullable=false)
    private String password;

    public String getDecryptedPassword() {
        return BasicAuthenticationConfiguration.decryptPassword(this.password);
    }

    public void setEncryptedPassword(String password) {
        this.password = BasicAuthenticationConfiguration.encryptPassword(password);
    }

    private static String decryptPassword(String encryptedPassword) {
        if (StringUtils.isEmpty((CharSequence)encryptedPassword)) {
            return encryptedPassword;
        }
        try {
            return TextCipher.decrypt(encryptedPassword);
        }
        catch (Exception e) {
            throw new DecryptingException(e);
        }
    }

    private static String encryptPassword(String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return password;
        }
        try {
            return TextCipher.encrypt(password);
        }
        catch (Exception e) {
            throw new EncryptingException(e);
        }
    }

    public static BasicAuthenticationConfigurationBuilder builder() {
        return new BasicAuthenticationConfigurationBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public BasicAuthenticationConfiguration() {
    }

    @ConstructorProperties(value={"id", "name", "username", "password"})
    public BasicAuthenticationConfiguration(String id, String name, String username, String password) {
        this.id = id;
        this.name = name;
        this.username = username;
        this.password = password;
    }

    public static class BasicAuthenticationConfigurationBuilder {
        private String id;
        private String name;
        private String username;
        private String password;

        public BasicAuthenticationConfigurationBuilder encryptedPassword(String password) {
            this.password = BasicAuthenticationConfiguration.encryptPassword(password);
            return this;
        }

        BasicAuthenticationConfigurationBuilder() {
        }

        public BasicAuthenticationConfigurationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public BasicAuthenticationConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BasicAuthenticationConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        public BasicAuthenticationConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        public BasicAuthenticationConfiguration build() {
            return new BasicAuthenticationConfiguration(this.id, this.name, this.username, this.password);
        }

        public String toString() {
            return "BasicAuthenticationConfiguration.BasicAuthenticationConfigurationBuilder(id=" + this.id + ", name=" + this.name + ", username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

