/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.eventaction;

import com.suncode.pwfl.component.ComponentDefinition;
import com.suncode.pwfl.component.ComponentDefinitionBuilder;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.workflow.form.eventaction.Event;
import com.suncode.pwfl.workflow.form.eventaction.EventActionDefinition;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class EventActionDefinitionBuilder
extends ComponentDefinitionBuilder<EventActionDefinitionBuilder> {
    private final List<EventBuilder> events = new ArrayList<EventBuilder>();

    public EventActionDefinitionBuilder(Translator translator) {
        super(translator);
    }

    @Override
    public ComponentDefinition create() {
        return new EventActionDefinition(new ComponentDefinition(this.id, this.documentationLink, this.name, this.description, this.icon, this.categories, this.parameters, Collections.emptyList(), null), this.events.stream().map(EventBuilder::build).collect(Collectors.toList()));
    }

    @Override
    protected EventActionDefinitionBuilder getThis() {
        return this;
    }

    public EventBuilder event(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        EventBuilder event = new EventBuilder(new Event.EventBuilder().name(name));
        this.events.add(event);
        return event;
    }

    public class EventBuilder {
        private final Event.EventBuilder builder;
        private final List<EventPropertyBuilder> properties = new ArrayList<EventPropertyBuilder>();

        public EventBuilder description(String description) {
            this.builder.description(description);
            return this;
        }

        public EventBuilder event(String name) {
            return EventActionDefinitionBuilder.this.event(name);
        }

        public EventPropertyBuilder property(String id) {
            EventPropertyBuilder builder = new EventPropertyBuilder(id);
            this.properties.add(builder);
            return builder;
        }

        private Event build() {
            this.properties.forEach(property -> this.builder.property(property.id, property.name, property.description, property.type));
            return this.builder.build(EventActionDefinitionBuilder.this.translator);
        }

        @ConstructorProperties(value={"builder"})
        public EventBuilder(Event.EventBuilder builder) {
            this.builder = builder;
        }

        public class EventPropertyBuilder {
            private final String id;
            private String name;
            private String description;
            private Type<?> type;

            public EventBuilder event(String name) {
                return EventActionDefinitionBuilder.this.event(name);
            }

            public EventPropertyBuilder property(String id) {
                return EventBuilder.this.property(id);
            }

            @ConstructorProperties(value={"id"})
            public EventPropertyBuilder(String id) {
                this.id = id;
            }

            public EventPropertyBuilder name(String name) {
                this.name = name;
                return this;
            }

            public EventPropertyBuilder description(String description) {
                this.description = description;
                return this;
            }

            public EventPropertyBuilder type(Type<?> type) {
                this.type = type;
                return this;
            }
        }
    }
}

