/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl;

import com.google.common.collect.Maps;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.translation.Translator;
import java.util.Map;

public class SystemException
extends RuntimeException {
    private static final long serialVersionUID = -4829796348584618764L;
    private Map<String, Object> properties = Maps.newLinkedHashMap();
    private Translator translator;
    private String localizedMessageKey;
    private Object[] localizedMessageArgs;

    public SystemException(String message) {
        super(message);
    }

    public SystemException(String message, Translator translator) {
        this(message);
        this.translator = translator;
    }

    public SystemException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public SystemException(String message, Throwable throwable, Translator translator) {
        this(message, throwable);
        this.translator = translator;
    }

    public SystemException set(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public <T> T get(String key) {
        return (T)this.properties.get(key);
    }

    public SystemException localizedMessage(String key, Object ... args) {
        this.localizedMessageKey = key;
        this.localizedMessageArgs = args;
        return this;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        if (!this.properties.isEmpty()) {
            sb.append(" ").append(this.properties);
        }
        return sb.toString();
    }

    @Override
    public String getLocalizedMessage() {
        if (this.localizedMessageKey != null) {
            if (this.translator == null) {
                return MessageHelper.getMessage((String)this.localizedMessageKey, (Object[])this.localizedMessageArgs);
            }
            return this.translator.getMessage(this.localizedMessageKey, this.localizedMessageArgs);
        }
        return super.getMessage();
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        String message = this.getMessage();
        return message != null ? s + ": " + message : s;
    }

    public static SystemException wrap(Throwable exception) {
        return SystemException.wrap(exception, null);
    }

    public static SystemException wrap(Throwable exception, Translator translator) {
        if (exception instanceof SystemException) {
            return (SystemException)exception;
        }
        return new SystemException(exception.getMessage(), exception, translator);
    }
}

